/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen.carver;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class MidnightCaveCarver
extends CaveWorldCarver {
    private final float radiusScale;

    public MidnightCaveCarver(Codec<CaveCarverConfiguration> codec, float radiusScale) {
        super(codec);
        this.radiusScale = radiusScale;
    }

    protected float m_213592_(RandomSource rand) {
        return super.m_213592_(rand) * this.radiusScale;
    }

    protected boolean carveBlock(CarvingContext ctx, CaveCarverConfiguration cfg, ChunkAccess chunkAccess, Function<BlockPos, Holder<Biome>> biomeAccess, CarvingMask mask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean foundSurface) {
        return this.carveBlock(chunkAccess, cfg, ctx, biomeAccess, mask, pos, checkPos, aquifer, foundSurface);
    }

    private boolean carveBlock(ChunkAccess chunk, CaveCarverConfiguration config, CarvingContext context, Function<BlockPos, Holder<Biome>> biomeAccesor, CarvingMask carvingMask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean foundSurface) {
        BlockState blockState = chunk.m_8055_((BlockPos)pos);
        if (blockState.m_60713_((Block)MnBlocks.NIGHT_GRASS.get())) {
            foundSurface.setTrue();
        }
        if (!this.m_224910_((CarverConfiguration)config, blockState)) {
            return false;
        }
        BlockState carveState = this.getCarveState(context, config, (BlockPos)pos, aquifer);
        if (carveState == null) {
            return false;
        }
        chunk.m_6978_((BlockPos)pos, carveState, false);
        if (aquifer.m_142203_() && !carveState.m_60819_().m_76178_()) {
            chunk.m_8113_((BlockPos)pos);
        }
        if (foundSurface.isTrue()) {
            checkPos.m_122159_((Vec3i)pos, Direction.DOWN);
            if (chunk.m_8055_((BlockPos)checkPos).m_60713_((Block)MnBlocks.NIGHT_DIRT.get())) {
                context.m_190646_(biomeAccesor, chunk, (BlockPos)checkPos, !carveState.m_60819_().m_76178_()).ifPresent(state -> {
                    chunk.m_6978_((BlockPos)checkPos, state, false);
                    if (!state.m_60819_().m_76178_()) {
                        chunk.m_8113_((BlockPos)checkPos);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    protected BlockState getCarveState(CarvingContext context, CaveCarverConfiguration config, BlockPos pos, Aquifer aquifer) {
        if (pos.m_123342_() <= config.f_159090_.m_142322_((WorldGenerationContext)context)) {
            return f_64982_.m_76188_();
        }
        return aquifer.m_207104_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()), 0.0);
    }
}

