/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.gen;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;

public class MidnightTerrainProvider {
    private static float clampedInvLerp(float start, float end, float delta) {
        return Mth.m_14036_((float)Mth.m_184655_((float)delta, (float)start, (float)end), (float)0.0f, (float)1.0f);
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> erosionIslandSpline(I erosion, I weirdness, float oceanDepth) {
        return CubicSpline.m_184252_(erosion).m_216117_(-1.0f, MidnightTerrainProvider.ridgeIslandSpline(weirdness, oceanDepth, 0.0f)).m_216117_(0.0f, MidnightTerrainProvider.ridgeIslandSpline(weirdness, oceanDepth, 0.35f)).m_216117_(1.0f, MidnightTerrainProvider.ridgeIslandSpline(weirdness, oceanDepth, 0.0f)).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeIslandSpline(I weirdness, float oceanDepth, float erosionAddition) {
        return CubicSpline.m_184252_(weirdness).m_216114_(-1.0f, 0.05f + erosionAddition / 2.0f).m_216114_(-0.66666f, 0.05f + erosionAddition).m_216114_(-0.43f, 0.03f).m_216114_(-0.35f, oceanDepth).m_216114_(0.35f, oceanDepth).m_216114_(0.43f, 0.03f).m_216114_(0.66666f, 0.05f + erosionAddition).m_216114_(1.0f, 0.05f + erosionAddition / 2.0f).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> offset(I continents, I erosion, I ridges, I weirdness) {
        return CubicSpline.m_184252_(continents).m_216117_(-1.0f, MidnightTerrainProvider.erosionIslandSpline(erosion, weirdness, -0.22f)).m_216117_(-0.65f, MidnightTerrainProvider.erosionIslandSpline(erosion, weirdness, -0.12f)).m_216114_(-0.6f, -0.12f).m_216114_(-0.52f, -0.12f).m_216117_(-0.45f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.0f, true)).m_216117_(-0.41f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.0f, true)).m_216117_(-0.38f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.0f, false)).m_216117_(0.0f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.0f, false)).m_216117_(0.08f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.15f, false)).m_216117_(1.0f, MidnightTerrainProvider.erosionSpline(erosion, ridges, 0.5f, false)).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> erosionSpline(I erosion, I ridges, float inlandAmount, boolean atCoast) {
        CubicSpline.Builder builder = CubicSpline.m_184252_(erosion);
        float ridgeOffset = inlandAmount > 0.0f ? 0.33f + inlandAmount / 4.0f : -0.17f;
        CubicSpline<C, I> mountainPeak = MidnightTerrainProvider.newRidgeSpline(ridges, ridgeOffset, 0.35f + inlandAmount / 4.0f, 0.45f + inlandAmount / 3.0f, 0.65f + inlandAmount / 2.0f, 1.0f + inlandAmount);
        CubicSpline<C, I> upperMountainEdge = MidnightTerrainProvider.newRidgeSpline(ridges, ridgeOffset > 0.0f ? ridgeOffset * 0.5f : ridgeOffset, 0.2f, 0.3f, 0.45f, 0.58f);
        CubicSpline<C, I> lowerMountainEdge = MidnightTerrainProvider.newRidgeSpline(ridges, -0.15f, 0.15f, 0.25f, 0.4f, 0.56f);
        CubicSpline<C, I> flatWithBlackRidgeEdge = MidnightTerrainProvider.newRidgeSpline(ridges, -0.15f, 0.03f, 0.03f, 0.1f, 0.15f);
        CubicSpline<C, I> flatWithBlackRidgeCentre = MidnightTerrainProvider.newRidgeSpline(ridges, -0.15f, 0.03f, 0.03f, 0.1f, 0.2f);
        CubicSpline<C, I> bogWithBlackRidgeEdge = MidnightTerrainProvider.newRidgeSpline(ridges, -0.02f, -0.02f, 0.03f, 0.1f, 0.15f);
        CubicSpline<C, I> bogWithBlackRidgeCentre = MidnightTerrainProvider.newRidgeSpline(ridges, -0.02f, -0.02f, 0.03f, 0.1f, 0.2f);
        CubicSpline<C, I> flattestTerrain = MidnightTerrainProvider.newRidgeSpline(ridges, -0.15f, 0.03f, 0.03f, 0.03f, 0.03f);
        CubicSpline<C, I> marshTerrain = MidnightTerrainProvider.newRidgeSpline(ridges, -0.03f, -0.03f, 0.03f, 0.03f, 0.03f);
        builder.m_216117_(-0.51f, MidnightTerrainProvider.newRidgeSpline(ridges, -0.15f, 0.03f, 0.03f, 0.32f, 0.32f, true));
        builder.m_216117_(-0.49f, flattestTerrain);
        builder.m_216117_(-0.4f, flattestTerrain);
        if (atCoast) {
            builder.m_216117_(-0.38f, flatWithBlackRidgeEdge);
            builder.m_216117_(-0.34f, flatWithBlackRidgeCentre);
            builder.m_216117_(-0.3f, flatWithBlackRidgeEdge);
        } else {
            builder.m_216117_(-0.38f, bogWithBlackRidgeEdge);
            builder.m_216117_(-0.34f, bogWithBlackRidgeCentre);
            builder.m_216117_(-0.3f, bogWithBlackRidgeEdge);
        }
        builder.m_216117_(-0.28f, flattestTerrain);
        builder.m_216117_(-0.23f, lowerMountainEdge);
        builder.m_216117_(-0.2f, upperMountainEdge);
        builder.m_216117_(0.0f, mountainPeak);
        builder.m_216117_(0.2f, upperMountainEdge);
        builder.m_216117_(0.23f, lowerMountainEdge);
        builder.m_216117_(0.28f, flattestTerrain);
        builder.m_216117_(0.3f, flatWithBlackRidgeEdge);
        builder.m_216117_(0.34f, flatWithBlackRidgeCentre);
        builder.m_216117_(0.38f, flatWithBlackRidgeEdge);
        if (atCoast) {
            builder.m_216117_(0.4f, flattestTerrain);
            builder.m_216117_(0.49f, flattestTerrain);
        } else {
            builder.m_216117_(0.4f, marshTerrain);
            builder.m_216117_(0.49f, marshTerrain);
        }
        builder.m_216114_(0.51f, 0.4f);
        return builder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> newRidgeSpline(I ridges, float valleyOffset, float lowOffset, float midOffset, float highOffset, float peakOffset, boolean alternatePoints) {
        CubicSpline.Builder builder = CubicSpline.m_184252_(ridges);
        builder.m_216114_(-1.0f, valleyOffset);
        builder.m_216114_(-0.55f, lowOffset);
        if (alternatePoints) {
            builder.m_216114_(-0.3f, midOffset);
            builder.m_216114_(-0.05f, highOffset);
        } else {
            builder.m_216114_(0.0f, midOffset);
            builder.m_216114_(0.4f, highOffset);
        }
        builder.m_216114_(1.0f, peakOffset);
        return builder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> newRidgeSpline(I ridges, float valleyOffset, float lowOffset, float midOffset, float highOffset, float peakOffset) {
        return MidnightTerrainProvider.newRidgeSpline(ridges, valleyOffset, lowOffset, midOffset, highOffset, peakOffset, false);
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> factor(I continents, I erosion, I ridges) {
        CubicSpline erosionSpline = CubicSpline.m_184252_(erosion).m_216114_(0.48f, 7.5f).m_216114_(0.5f, 0.5f).m_184297_();
        return CubicSpline.m_184252_(continents).m_216114_(-0.49f, 7.5f).m_216117_(-0.45f, erosionSpline).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> jaggedness(I continents, I erosion, I ridges) {
        return CubicSpline.m_184252_(continents).m_184298_(-0.5f, 0.0f, 0.0f).m_216117_(-0.47f, MidnightTerrainProvider.erosionJaggednessSpline(erosion, ridges, 0.0f)).m_216117_(1.0f, MidnightTerrainProvider.erosionJaggednessSpline(erosion, ridges, 0.2f)).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> erosionJaggednessSpline(I erosion, I ridges, float addition) {
        return CubicSpline.m_184252_(erosion).m_216117_(-1.0f, MidnightTerrainProvider.ridgeJaggednessSpline(ridges, 0.4f + addition)).m_216117_(-0.62f, MidnightTerrainProvider.ridgeJaggednessSpline(ridges, 0.3f + addition * 0.5f)).m_184298_(-0.59f, 0.0f, 0.0f).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeJaggednessSpline(I ridges, float scale) {
        return CubicSpline.m_184252_(ridges).m_216114_(0.16f, 0.0f).m_216114_(0.4f, scale * 0.5f).m_216114_(1.0f, scale).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> erosionFactorSpline(I erosion, I ridges) {
        return CubicSpline.m_184252_(erosion).m_184298_(-0.02f, 7.5f, 0.0f).m_216117_(0.0f, MidnightTerrainProvider.ridgeFactorSpline(ridges)).m_216117_(0.2f, MidnightTerrainProvider.ridgeFactorSpline(ridges)).m_184298_(0.22f, 7.5f, 0.0f).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeFactorSpline(I ridges) {
        return CubicSpline.m_184252_(ridges).m_216114_(0.2f, 7.5f).m_216114_(0.3f, 0.3f).m_184297_();
    }
}

