/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.biome.factory;

import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.builder.MnBiomeBuilder;
import com.crypticmushroom.minecraft.midnight.common.world.biome.effects.MidnightBiomeModifier;
import com.crypticmushroom.minecraft.midnight.common.world.biome.util.MnBiomeDefaultFeatures;
import java.util.function.BiFunction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public abstract class MnBiomeFactory
implements BiFunction<BootstapContext<Biome>, MnBiomeBuilder, MnBiomeBuilder> {
    private static final int DEFAULT_FOG_COLOR = 1777718;
    private static final int DEFAULT_WATER_FOG_COLOR = 788009;
    private static final int DEFAULT_WATER_COLOR = 788009;

    @Override
    public final MnBiomeBuilder apply(BootstapContext<Biome> bootstrap, MnBiomeBuilder builder) {
        return builder.hasPrecipitation(this.hasPrecipitation(bootstrap)).temperature(this.temperature(bootstrap)).downfall(this.downfall(bootstrap)).specialEffects(this.specialEffects(bootstrap).m_48018_()).mobSpawnSettings(this.mobSpawnSettings(bootstrap).m_48381_()).generationSettings(this.defaultGenerationSettingsBuilder(bootstrap).m_255380_()).temperatureAdjustment(this.temperatureModifier(bootstrap));
    }

    @Deprecated(forRemoval=true)
    public Biome.Precipitation precipitation(BootstapContext<Biome> bootstrap) {
        return Biome.Precipitation.NONE;
    }

    public boolean hasPrecipitation(BootstapContext<Biome> bootstrap) {
        return this.precipitation(bootstrap) != Biome.Precipitation.NONE;
    }

    public float temperature(BootstapContext<Biome> bootstrap) {
        return 1.0f;
    }

    public float downfall(BootstapContext<Biome> bootstrap) {
        return 0.0f;
    }

    public BiomeSpecialEffects.Builder specialEffects(BootstapContext<Biome> bootstrap) {
        return new BiomeSpecialEffects.Builder().m_48029_(new AmbientParticleSettings((ParticleOptions)MnParticleTypes.AMBIENT_SPORE.get(), 0.004f)).m_48019_(1777718).m_48040_(854548).m_48034_(788009).m_48037_(788009);
    }

    public MidnightBiomeModifier.Builder customEffects(BootstapContext<Biome> bootstrap) {
        return new MidnightBiomeModifier.Builder((HolderGetter<Biome>)bootstrap.m_255420_(Registries.f_256952_));
    }

    public MobSpawnSettings.Builder mobSpawnSettings(BootstapContext<Biome> bootstrap) {
        return new MobSpawnSettings.Builder();
    }

    public BiomeGenerationSettings.Builder defaultGenerationSettingsBuilder(BootstapContext<Biome> bootstrap) {
        return MnBiomeDefaultFeatures.globalGeneration(bootstrap);
    }

    public Biome.TemperatureModifier temperatureModifier(BootstapContext<Biome> bootstrap) {
        return Biome.TemperatureModifier.NONE;
    }
}

