/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.world.biome.effects;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomeModifiers;
import com.crypticmushroom.minecraft.midnight.common.world.manager.MidnightBiomeModifierManager;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import org.jetbrains.annotations.Nullable;

public final class MidnightBiomeModifier
implements BiomeModifier {
    public static final int DEFAULT_NIGHT_GRASS_COLOR = 5270648;
    public static final int DEFAULT_SHADOWROOT_COLOR = 3813716;
    public static final float DEFAULT_FOG_DISTANCE = 8.0f;
    public static final MidnightBiomeModifier DEFAULT = new MidnightBiomeModifier(5270648, 3813716, 8.0f);
    @Nullable
    private final Holder<Biome> biome;
    private final int nightGrassColor;
    private final int shadowrootLeavesColor;
    private final float fogDistance;

    public MidnightBiomeModifier(int nightGrassColor, int shadowrootLeavesColor, float fogDistance) {
        this(null, nightGrassColor, shadowrootLeavesColor, fogDistance);
    }

    public MidnightBiomeModifier(@Nullable Holder<Biome> biome, int nightGrassColor, int shadowrootLeavesColor, float fogDistance) {
        this.biome = biome;
        this.nightGrassColor = nightGrassColor;
        this.shadowrootLeavesColor = shadowrootLeavesColor;
        this.fogDistance = fogDistance;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.BEFORE_EVERYTHING || this.biome == null || this.biome != biome) {
            return;
        }
        MidnightBiomeModifierManager.Server.get().add(biome, this);
    }

    public Codec<MidnightBiomeModifier> codec() {
        return (Codec)MnBiomeModifiers.Serializers.MIDNIGHT_BIOME.get();
    }

    @Deprecated
    @Nullable
    public Holder<Biome> getBiome() {
        return this.biome;
    }

    public int getNightGrassColor() {
        return this.nightGrassColor;
    }

    public int getShadowrootLeavesColor() {
        return this.shadowrootLeavesColor;
    }

    public float getFogDistance() {
        return this.fogDistance;
    }

    public static final class Builder {
        private final HolderGetter<Biome> holderGetter;
        private int nightGrassColor = 5270648;
        private int shadowrootLeavesColor = 3813716;
        private float fogDistance = 8.0f;

        public Builder(HolderGetter<Biome> holderGetter) {
            this.holderGetter = holderGetter;
        }

        public Builder nightGrassColor(int grassColor) {
            this.nightGrassColor = grassColor;
            return this;
        }

        public Builder shadowrootLeavesColor(int shadowrootColor) {
            this.shadowrootLeavesColor = shadowrootColor;
            return this;
        }

        public Builder fogDistance(int fogDistance) {
            this.fogDistance = fogDistance;
            return this;
        }

        public MidnightBiomeModifier build(ResourceKey<Biome> biome) {
            return new MidnightBiomeModifier((Holder<Biome>)this.holderGetter.m_255043_(biome), this.nightGrassColor, this.shadowrootLeavesColor, this.fogDistance);
        }
    }
}

