/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.util;

import java.util.function.BiFunction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class MathUtil {
    public static boolean chanceMet(Level level, double chance) {
        return MathUtil.chanceMet(level.f_46441_, chance);
    }

    public static boolean chanceMet(Level level, float chance) {
        return MathUtil.chanceMet(level.f_46441_, chance);
    }

    public static boolean chanceMet(RandomSource random, double chance) {
        return chance >= 1.0 || random.m_188500_() <= chance;
    }

    public static boolean chanceMet(RandomSource random, float chance) {
        return chance >= 1.0f || random.m_188501_() <= chance;
    }

    public static float moveTowardValue(float original, float destination, float interval) {
        return MathUtil.moveTowardValue(Float.valueOf(original), Float.valueOf(destination), Float.valueOf(interval), Float::sum, (a, b) -> Float.valueOf(Float.sum(a.floatValue(), -b.floatValue()))).floatValue();
    }

    public static double moveTowardValue(double original, double destination, double interval) {
        return MathUtil.moveTowardValue(Double.valueOf(original), Double.valueOf(destination), Double.valueOf(interval), Double::sum, (a, b) -> Double.sum(a, -b.doubleValue()));
    }

    public static float moveTowardValue(float original, float destination, float interval, float min, float max) {
        return MathUtil.moveTowardValue(Float.valueOf(original), Float.valueOf(destination), Float.valueOf(interval), Float.valueOf(min), Float.valueOf(max), Float::sum, (a, b) -> Float.valueOf(Float.sum(a.floatValue(), -b.floatValue()))).floatValue();
    }

    public static double moveTowardValue(double original, double destination, double interval, double min, double max) {
        return MathUtil.moveTowardValue(original, destination, interval, min, max, Double::sum, (a, b) -> Double.sum(a, -b.doubleValue()));
    }

    public static <N extends Number> N moveTowardValue(N original, N destination, N interval, BiFunction<N, N, N> sumImpl, BiFunction<N, N, N> diffImpl) {
        if (((Comparable)((Object)original)).compareTo(destination) < 0) {
            return (N)MathUtil.min((Number)sumImpl.apply(original, interval), destination);
        }
        if (((Comparable)((Object)original)).compareTo(destination) > 0) {
            return (N)MathUtil.max((Number)diffImpl.apply(original, interval), destination);
        }
        return original;
    }

    public static <N extends Number> N moveTowardValue(N original, N destination, N interval, N min, N max, BiFunction<N, N, N> sumImpl, BiFunction<N, N, N> diffImpl) {
        return MathUtil.clamp(MathUtil.moveTowardValue(original, destination, interval, sumImpl, diffImpl), min, max);
    }

    public static <N extends Number> N min(N a, N b) {
        return ((Comparable)((Object)a)).compareTo(b) <= 0 ? a : b;
    }

    public static <N extends Number> N max(N a, N b) {
        return ((Comparable)((Object)a)).compareTo(b) >= 0 ? a : b;
    }

    public static <N extends Number> N clamp(N value, N min, N max) {
        if (((Comparable)((Object)value)).compareTo(min) < 0) {
            return min;
        }
        return ((Comparable)((Object)value)).compareTo(max) > 0 ? max : value;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static float toRadiansStrict(float angdeg) {
        return angdeg / 180.0f * (float)Math.PI;
    }

    public static float toDegreesStrict(float angrad) {
        return angrad / (float)Math.PI * 180.0f;
    }

    public static float tan(float x) {
        return (float)Math.tan(x);
    }

    public static float asin(float x) {
        return (float)Math.asin(x);
    }

    public static float acos(float x) {
        return (float)Math.acos(x);
    }

    public static float atan(float x) {
        return (float)Math.atan(x);
    }

    public static float atan2(float y, float x) {
        return (float)Mth.m_14136_((double)y, (double)x);
    }

    public static float cbrt(float x) {
        return (float)Math.cbrt(x);
    }

    @Deprecated
    public static float random() {
        return (float)Math.random();
    }

    public static float relerp(float a, float b, float p, float q, float t) {
        return Mth.m_14179_((float)Mth.m_184655_((float)t, (float)a, (float)b), (float)p, (float)q);
    }

    public static double relerp(double a, double b, double p, double q, double t) {
        return Mth.m_14139_((double)Mth.m_14112_((double)t, (double)a, (double)b), (double)p, (double)q);
    }

    @Deprecated(forRemoval=true)
    public static double average(long ... values) {
        long i = 0L;
        for (long j : values) {
            i += j;
        }
        return (double)i / (double)values.length;
    }

    public static float distSq(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    public static float dist(float x1, float y1, float x2, float y2) {
        return Mth.m_14116_((float)MathUtil.distSq(x1, y1, x2, y2));
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt(MathUtil.distSq(x1, y1, x2, y2));
    }

    public static Vec3 rotatePitchAndYaw(Vec3 vec, float pitch, float yaw) {
        return MathUtil.rotateYaw(MathUtil.rotatePitch(vec, pitch), yaw);
    }

    public static Vec3 rotatePitch(Vec3 vec, float pitch) {
        float f = Mth.m_14089_((float)pitch);
        float f1 = Mth.m_14031_((float)pitch);
        double d0 = vec.f_82479_;
        double d1 = vec.f_82480_ * (double)f + vec.f_82481_ * (double)f1;
        double d2 = vec.f_82481_ * (double)f - vec.f_82480_ * (double)f1;
        return new Vec3(d0, d1, d2);
    }

    public static Vec3 rotateYaw(Vec3 vec, float yaw) {
        float f = Mth.m_14089_((float)yaw);
        float f1 = Mth.m_14031_((float)yaw);
        double d0 = vec.f_82479_ * (double)f + vec.f_82481_ * (double)f1;
        double d1 = vec.f_82480_;
        double d2 = vec.f_82481_ * (double)f - vec.f_82479_ * (double)f1;
        return new Vec3(d0, d1, d2);
    }
}

