/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.util;

import com.crypticmushroom.minecraft.midnight.common.block.HangingLeavesGrowingBlock;
import com.crypticmushroom.minecraft.midnight.common.block.MidnightDirtBlock;
import com.crypticmushroom.minecraft.midnight.common.block.MnCraftingTableBlock;
import com.crypticmushroom.minecraft.midnight.common.block.ShroomCapBlock;
import com.crypticmushroom.minecraft.midnight.common.block.StripableRotatedPillarBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.BoxConfigurableBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.DirectionalBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.FloatingBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.GrowablePlantBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.HangingBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.HangingLeavesBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.MnDoublePlantBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.MnDoublePlantSaplingBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.MnSaplingBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.WaterloggablePlantBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnVoxelShapes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlockEntities;
import com.crypticmushroom.minecraft.midnight.common.registry.MnCreativeModeTabs;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.builder.MnBlockBuilder;
import com.crypticmushroom.minecraft.midnight.data.provider.model.MnBlockModelProvider;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import com.crypticmushroom.minecraft.registry.api.block.AbstractCeilingHangingSignBlock;
import com.crypticmushroom.minecraft.registry.api.block.AbstractStandingSignBlock;
import com.crypticmushroom.minecraft.registry.data.provider.model.ICrypticModelProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;

public class BlockBuilderPresets {
    public static MnBlockBuilder<Block> stone() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283947_)).instrument(NoteBlockInstrument.BASEDRUM)).sound(SoundType.f_56742_)).strength(1.5, 6)).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<DropExperienceBlock> stoneXPOre(int minXP, int maxXP) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<DropExperienceBlock>(p -> new DropExperienceBlock(p, (IntProvider)UniformInt.m_146622_((int)minXP, (int)maxXP))).mapColor(MapColor.f_283947_)).instrument(NoteBlockInstrument.BASEDRUM)).sound(SoundType.f_56742_)).strength(3, 3)).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(MnBlockTags.ORES);
    }

    public static MnBlockBuilder<Block> stoneBricks(RegistryObject<? extends Block> block) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder(block).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS)).tag(BlockTags.f_13091_);
    }

    @Deprecated
    public static MnBlockBuilder<StairBlock> stairs(RegistryObject<? extends Block> block) {
        return BlockBuilderPresets.stairs(block, false);
    }

    public static MnBlockBuilder<StairBlock> stairs(RegistryObject<? extends Block> block, boolean wooden) {
        return (MnBlockBuilder)new MnBlockBuilder<StairBlock>(p -> new StairBlock(() -> ((Block)block.get()).m_49966_(), p), block).tag(wooden ? BlockTags.f_13096_ : BlockTags.f_13030_);
    }

    @Deprecated
    public static MnBlockBuilder<SlabBlock> slab(RegistryObject<? extends Block> block) {
        return BlockBuilderPresets.slab(block, false);
    }

    public static MnBlockBuilder<SlabBlock> slab(RegistryObject<? extends Block> block, boolean wooden) {
        return (MnBlockBuilder)new MnBlockBuilder<SlabBlock>(SlabBlock::new, block).tag(wooden ? BlockTags.f_13097_ : BlockTags.f_13031_);
    }

    @Deprecated
    public static MnBlockBuilder<MidnightDirtBlock> dirt() {
        return BlockBuilderPresets.dirt(false);
    }

    public static MnBlockBuilder<MidnightDirtBlock> dirt(boolean wet) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<MidnightDirtBlock>(MidnightDirtBlock::new).mapColor(MapColor.f_283762_)).sound(SoundType.f_56739_)).strength(0.5)).mineableWithShovel()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(wet ? MnBlockTags.WET_SOILS : MnBlockTags.SOILS);
    }

    public static MnBlockBuilder<GlassBlock> glass() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<GlassBlock>(GlassBlock::new).instrument(NoteBlockInstrument.HAT)).noOcclusion()).sound(SoundType.f_56744_)).strength(0.3)).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<IronBarsBlock> glassPane() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<IronBarsBlock>(IronBarsBlock::new).instrument(NoteBlockInstrument.HAT)).noOcclusion()).sound(SoundType.f_56744_)).strength(0.3)).blockItem((models, block) -> models.generated(block, new Function[]{b -> models.texture((Supplier)b, null, "pane")}), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS)).tag(Tags.Blocks.GLASS_PANES);
    }

    private static MnBlockBuilder<Block> woodPlanks(boolean shroom) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).sound(SoundType.f_56736_)).strength(2)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS)).tag(shroom ? MnBlockTags.SHROOM_PLANKS : MnBlockTags.PLANKS);
    }

    public static MnBlockBuilder<Block> woodPlanks() {
        return BlockBuilderPresets.woodPlanks(false);
    }

    public static MnBlockBuilder<Block> shroomPlanks() {
        return BlockBuilderPresets.woodPlanks(true);
    }

    @Deprecated
    public static MnBlockBuilder<RotatedPillarBlock> log() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<RotatedPillarBlock>(RotatedPillarBlock::new).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).sound(SoundType.f_56736_)).strength(2)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<RotatedPillarBlock> log(TagKey<Block> logTag) {
        return (MnBlockBuilder)BlockBuilderPresets.log().tag(logTag);
    }

    @Deprecated
    public static MnBlockBuilder<StripableRotatedPillarBlock> log(Supplier<? extends Block> stripped) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<StripableRotatedPillarBlock>(p -> new StripableRotatedPillarBlock((BlockBehaviour.Properties)p, stripped)).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).sound(SoundType.f_56736_)).strength(2)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<StripableRotatedPillarBlock> log(Supplier<? extends Block> stripped, TagKey<Block> logTag) {
        return (MnBlockBuilder)BlockBuilderPresets.log(stripped).tag(logTag);
    }

    public static MnBlockBuilder<Block> crystalRock() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().sound((SoundType)MnSoundTypes.CRYSTAL)).strength(4, 4)).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<WaterloggablePlantBlock> crystal(TagKey<Block> growableBlocks) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<WaterloggablePlantBlock>(p -> new WaterloggablePlantBlock((BlockBehaviour.Properties)p, growableBlocks, true, MnVoxelShapes.BOX_12_13)).mapColor(MapColor.f_283765_)).forceSolidOff()).pushReaction(PushReaction.DESTROY)).noCollission()).sound((SoundType)MnSoundTypes.CRYSTAL)).strength(4, 4)).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((models, block) -> models.generated(block), (Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<Block> metal() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283906_)).sound(SoundType.f_56743_)).requiresCorrectToolForDrops()).mineableWithPickaxe()).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS)).tag(MnBlockTags.STORAGE_BLOCKS);
    }

    public static MnBlockBuilder<ShroomCapBlock> shroomCap(int sporeColor) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<ShroomCapBlock>(p -> new ShroomCapBlock((BlockBehaviour.Properties)p, sporeColor)).mapColor(MapColor.f_283824_)).strength(1.7)).sound(SoundType.f_56719_)).mineableWithHoe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(MnBlockTags.SHROOM_CAPS);
    }

    public static MnBlockBuilder<Block> shroomStem() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283825_)).sound(SoundType.f_56763_)).strength(2)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(MnBlockTags.SHROOM_STEMS);
    }

    public static MnBlockBuilder<Block> thatch() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283824_)).sound(SoundType.f_56719_)).strength(0.8)).mineableWithHoe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<MnCraftingTableBlock> craftingTable() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<MnCraftingTableBlock>(MnCraftingTableBlock::new).mapColor(MapColor.f_283825_)).ignitedByLava()).instrument(NoteBlockInstrument.BASS)).sound(SoundType.f_56736_)).strength(2)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.FUNCTIONAL_BLOCKS);
    }

    public static MnBlockBuilder<LeavesBlock> leaves() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<LeavesBlock>(LeavesBlock::new).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).noOcclusion()).sound(SoundType.f_56740_)).isSuffocating(false)).strength(0.2)).mineableWithHoe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(MnBlockTags.LEAVES);
    }

    public static MnBlockBuilder<HangingLeavesBushBlock> hangingLeaves(Supplier<? extends Block> leaves, Supplier<TagKey<Block>> logTag) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<HangingLeavesBushBlock>(p -> new HangingLeavesBushBlock((BlockBehaviour.Properties)p, leaves, (TagKey<Block>)((TagKey)logTag.get()))).mapColor(MapColor.f_283915_)).pushReaction(PushReaction.DESTROY)).noCollission()).sound(SoundType.f_56758_)).isSuffocating(false)).strength(0.1)).mineableWithHoe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<HangingLeavesGrowingBlock> growingHangingLeaves(Supplier<? extends HangingLeavesBushBlock> hangingFrom) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<HangingLeavesGrowingBlock>(p -> new HangingLeavesGrowingBlock((BlockBehaviour.Properties)p, hangingFrom)).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).noOcclusion()).sound(SoundType.f_56740_)).isSuffocating(false)).strength(0.2)).mineableWithHoe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).tag(MnBlockTags.LEAVES);
    }

    public static MnBlockBuilder<Block> malignantPlantBlock() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder().mapColor(MapColor.f_283913_)).pushReaction(PushReaction.DESTROY)).sound(SoundType.f_154669_)).strength(1.5)).mineableWithAxe()).blockItem((Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static <T extends Block> MnBlockBuilder<T> simplePlant(MnBlockBuilder<T> builder) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)builder.noCollission()).instabreak()).blockItem((models, block) -> models.generated(block), (Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<MnSaplingBlock> sapling(AbstractTreeGrower treeGrower) {
        return BlockBuilderPresets.simplePlant((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<MnSaplingBlock>(p -> new MnSaplingBlock(treeGrower, (BlockBehaviour.Properties)p)).replaceable().mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(SoundType.f_56740_)).offsetType(BlockBehaviour.OffsetType.NONE));
    }

    private static <B extends MnDoublePlantSaplingBlock> MnBlockBuilder<B> saplingDouble(MnBlockBuilder<B> builder) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)builder.replaceable().mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(SoundType.f_56740_)).noCollision()).instabreak()).blockItem((models, block) -> models.generated(block, new Function[]{b -> models.texture((Supplier)b, "upper")}), (Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingDouble(AbstractTreeGrower treeGrower) {
        return BlockBuilderPresets.saplingDouble(new MnBlockBuilder<MnDoublePlantSaplingBlock>(p -> new MnDoublePlantSaplingBlock(treeGrower, (BlockBehaviour.Properties)p)));
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingDouble(AbstractTreeGrower treeGrower, double size, double height) {
        return BlockBuilderPresets.saplingDouble(new MnBlockBuilder<MnDoublePlantSaplingBlock>(p -> new MnDoublePlantSaplingBlock(treeGrower, (BlockBehaviour.Properties)p, size, height)));
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingDouble(AbstractTreeGrower treeGrower, VoxelShape lowerHitbox, VoxelShape upperHitbox) {
        return BlockBuilderPresets.saplingDouble(new MnBlockBuilder<MnDoublePlantSaplingBlock>(p -> new MnDoublePlantSaplingBlock(treeGrower, (BlockBehaviour.Properties)p, lowerHitbox, upperHitbox)));
    }

    public static MnBlockBuilder<BoxConfigurableBushBlock> plant(boolean replaceable, VoxelShape hitbox, BlockBehaviour.OffsetType offsetType, TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.simplePlant((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<BoxConfigurableBushBlock>(p -> new BoxConfigurableBushBlock((BlockBehaviour.Properties)p, plantableBlocks, false, hitbox, offsetType != BlockBehaviour.OffsetType.NONE)).replaceable(replaceable).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType)).offsetType(offsetType));
    }

    public static MnBlockBuilder<BoxConfigurableBushBlock> plant(boolean replaceable, BlockBehaviour.OffsetType offsetType, TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.plant(replaceable, MnVoxelShapes.BOX_12_13, offsetType, plantableBlocks, soundType);
    }

    public static MnBlockBuilder<BoxConfigurableBushBlock> plant(BlockBehaviour.OffsetType offsetType, TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.plant(false, MnVoxelShapes.BOX_12_13, offsetType, plantableBlocks, soundType);
    }

    public static MnBlockBuilder<HangingBushBlock> hangingPlant(TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.simplePlant((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<HangingBushBlock>(p -> new HangingBushBlock((BlockBehaviour.Properties)p, plantableBlocks)).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType));
    }

    public static MnBlockBuilder<HangingBushBlock> hangingShroom() {
        return BlockBuilderPresets.hangingPlant(MnBlockTags.SHROOM_GROWABLE, SoundType.f_56711_);
    }

    public static MnBlockBuilder<GrowablePlantBlock> growablePlant(boolean replaceable, Supplier<? extends MnDoublePlantBlock> doublePlant, TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.simplePlant((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<GrowablePlantBlock>(p -> new GrowablePlantBlock((BlockBehaviour.Properties)p, doublePlant, plantableBlocks, false)).replaceable(replaceable).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType));
    }

    public static MnBlockBuilder<GrowablePlantBlock> growableShroom(Supplier<? extends MnDoublePlantBlock> doublePlant) {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.growablePlant(false, doublePlant, MnBlockTags.SHROOM_GROWABLE, SoundType.f_56711_).lightLevel(9)).emissiveRendering(true);
    }

    private static <B extends MnDoublePlantBlock> MnBlockBuilder<B> tallPlant(MnBlockBuilder<B> builder, boolean replaceable, SoundType soundType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)builder.replaceable(replaceable).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType)).noCollision()).instabreak()).blockItem((models, block) -> models.generated(block, new Function[]{b -> models.texture((Supplier)b, "upper")}), (Supplier)MnCreativeModeTabs.NATURAL_BLOCKS);
    }

    public static MnBlockBuilder<MnDoublePlantBlock> tallPlant(boolean replaceable, TagKey<Block> plantableBlocks, SoundType soundType) {
        return BlockBuilderPresets.tallPlant(new MnBlockBuilder<MnDoublePlantBlock>(p -> new MnDoublePlantBlock((BlockBehaviour.Properties)p, plantableBlocks, false)), replaceable, soundType);
    }

    public static MnBlockBuilder<MnDoublePlantBlock> tallPlant(boolean replaceable, TagKey<Block> plantableBlocks, SoundType soundType, double size, double height) {
        return BlockBuilderPresets.tallPlant(new MnBlockBuilder<MnDoublePlantBlock>(p -> new MnDoublePlantBlock((BlockBehaviour.Properties)p, plantableBlocks, false, size, height)), replaceable, soundType);
    }

    public static MnBlockBuilder<MnDoublePlantBlock> tallPlant(boolean replaceable, TagKey<Block> plantableBlocks, SoundType soundType, VoxelShape lowerHitbox, VoxelShape upperHitbox) {
        return BlockBuilderPresets.tallPlant(new MnBlockBuilder<MnDoublePlantBlock>(p -> new MnDoublePlantBlock((BlockBehaviour.Properties)p, plantableBlocks, false, lowerHitbox, upperHitbox)), replaceable, soundType);
    }

    @Deprecated(forRemoval=true)
    public static MnBlockBuilder<MnDoublePlantBlock> tallShroom() {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.tallPlant(false, MnBlockTags.SHROOM_GROWABLE, SoundType.f_56711_).lightLevel(10)).emissiveRendering(true);
    }

    @Deprecated(forRemoval=true)
    public static MnBlockBuilder<MnDoublePlantBlock> tallShroom(double size, double height) {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.tallPlant(false, MnBlockTags.SHROOM_GROWABLE, SoundType.f_56711_, size, height).lightLevel(10)).emissiveRendering(true);
    }

    @Deprecated(forRemoval=true)
    public static MnBlockBuilder<MnDoublePlantBlock> tallShroom(VoxelShape lowerHitbox, VoxelShape upperHitbox) {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.tallPlant(false, MnBlockTags.SHROOM_GROWABLE, SoundType.f_56711_, lowerHitbox, upperHitbox).lightLevel(10)).emissiveRendering(true);
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingTallShroom(AbstractTreeGrower treeGrower) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.saplingDouble(treeGrower).tag(MnBlockTags.SHROOM_GROWABLE)).sound(SoundType.f_56711_)).lightLevel(10)).emissiveRendering(true);
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingTallShroom(AbstractTreeGrower treeGrower, double size, double height) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.saplingDouble(treeGrower, size, height).tag(MnBlockTags.SHROOM_GROWABLE)).sound(SoundType.f_56711_)).lightLevel(10)).emissiveRendering(true);
    }

    public static MnBlockBuilder<MnDoublePlantSaplingBlock> saplingTallShroom(AbstractTreeGrower treeGrower, VoxelShape lowerHitbox, VoxelShape upperHitbox) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.saplingDouble(treeGrower, lowerHitbox, upperHitbox).tag(MnBlockTags.SHROOM_GROWABLE)).sound(SoundType.f_56711_)).lightLevel(10)).emissiveRendering(true);
    }

    public static MnBlockBuilder<FloatingBushBlock> floatingWaterPlant(boolean replaceable) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<FloatingBushBlock>(FloatingBushBlock::new).replaceable(replaceable).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(SoundType.f_56752_)).noCollission()).blockItem((models, block) -> models.generated(block), (Supplier)MnCreativeModeTabs.NATURAL_BLOCKS)).instabreak();
    }

    public static MnBlockBuilder<DirectionalBushBlock> directionalPlant(VoxelShape[] voxelShapes, TagKey<Block> plantableBlocks, SoundType soundType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<DirectionalBushBlock>(p -> new DirectionalBushBlock((BlockBehaviour.Properties)p, plantableBlocks, voxelShapes)).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType)).noCollission()).instabreak();
    }

    public static MnBlockBuilder<? extends DirectionalBushBlock> crystalotus(VoxelShape[] voxelShapes, TagKey<Block> plantableBlocks, SoundType soundType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<1>(p -> new DirectionalBushBlock((BlockBehaviour.Properties)p, (TagKey)plantableBlocks, voxelShapes){

            public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
                List<Direction> orthagonalDirections = Arrays.stream(Direction.values()).filter(dir -> dir.m_122434_() != this.getFaceDirectionAttachedTo(state).m_122434_()).toList();
                for (Direction dir2 : orthagonalDirections) {
                    if (level.m_8055_(pos.m_121945_(dir2)).m_60795_()) continue;
                    return false;
                }
                return super.m_7898_(state, level, pos);
            }
        }).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(soundType)).noCollission()).instabreak();
    }

    public static MnBlockBuilder<? extends DirectionalBushBlock> shroomShelf() {
        return (MnBlockBuilder)BlockBuilderPresets.simplePlant((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<2>(p -> new DirectionalBushBlock((BlockBehaviour.Properties)p, (TagKey)MnBlockTags.SHROOM_GROWABLE, MnVoxelShapes.SHROOM_SHELF_BOXES){

            @Override
            public DirectionProperty getFacingProperty() {
                return MnBlockStateProperties.FACING_EXCEPT_DOWN;
            }
        }).mapColor(MapColor.f_283915_)).ignitedByLava()).pushReaction(PushReaction.DESTROY)).sound(SoundType.f_56711_)).tag(MnBlockTags.SHROOM_SHELVES);
    }

    private static MnBlockBuilder<DoorBlock> doorInternal(Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<DoorBlock>(p -> new DoorBlock(p, (BlockSetType)blockSetType.get())).noOcclusion()).blockStateAndModel((states, block) -> states.doorBlock((Supplier)block, states.texture((Supplier)block, "bottom"), states.texture((Supplier)block, "top"), ICrypticModelProvider.RenderType.CUTOUT))).blockItem((models, block) -> models.generated(block, new Function[]{b -> models.texture((ItemLike)((ItemLike)b.get()).m_5456_())}), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    private static MnBlockBuilder<DoorBlock> woodDoorInternal(Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.doorInternal(blockSetType).mapColor(MapColor.f_283825_)).ignitedByLava()).instrument(NoteBlockInstrument.BASS)).strength(3)).mineableWithAxe();
    }

    public static MnBlockBuilder<DoorBlock> woodDoor(Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodDoorInternal(blockSetType).tag(MnBlockTags.WOODEN_DOORS);
    }

    public static MnBlockBuilder<DoorBlock> shroomDoor(Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodDoorInternal(blockSetType).tag(MnBlockTags.SHROOM_DOORS);
    }

    public static MnBlockBuilder<DoorBlock> metalDoor(Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.doorInternal(blockSetType).mapColor(MapColor.f_283906_)).strength(5)).noOcclusion()).requiresCorrectToolForDrops()).mineableWithPickaxe()).needsTier((Tier)Tiers.IRON)).tag(MnBlockTags.METAL_DOORS);
    }

    private static MnBlockBuilder<FenceBlock> woodFenceInternal(Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<FenceBlock>(FenceBlock::new).mapColor(MapColor.f_283825_)).ignitedByLava()).instrument(NoteBlockInstrument.BASS)).strength(2, 3)).sound(SoundType.f_56736_)).mineableWithAxe()).blockStateAndModel((states, block) -> states.fenceBlock((Supplier)block, texture))).blockItem((models, block) -> models.fenceInventory(models.name(block), models.texture(texture)), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<FenceBlock> woodFence(Supplier<? extends Block> texture) {
        return (MnBlockBuilder)BlockBuilderPresets.woodFenceInternal(texture).tag(MnBlockTags.WOODEN_FENCES);
    }

    public static MnBlockBuilder<FenceBlock> shroomFence(Supplier<? extends Block> texture) {
        return (MnBlockBuilder)BlockBuilderPresets.woodFenceInternal(texture).tag(MnBlockTags.SHROOM_FENCES);
    }

    private static MnBlockBuilder<FenceGateBlock> woodFenceGateInternal(Supplier<? extends Block> texture, Supplier<WoodType> woodType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<FenceGateBlock>(p -> new FenceGateBlock(p, (WoodType)woodType.get())).mapColor(MapColor.f_283825_)).ignitedByLava()).instrument(NoteBlockInstrument.BASS)).strength(2, 3)).sound(SoundType.f_56736_)).mineableWithAxe()).blockStateAndModel((states, block) -> states.fenceGateBlock((Supplier)block, texture))).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<FenceGateBlock> woodFenceGate(Supplier<? extends Block> texture, Supplier<WoodType> woodType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodFenceGateInternal(texture, woodType).tag(MnBlockTags.WOODEN_FENCE_GATES);
    }

    public static MnBlockBuilder<FenceGateBlock> shroomFenceGate(Supplier<? extends Block> texture, Supplier<WoodType> woodType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodFenceGateInternal(texture, woodType).tag(MnBlockTags.SHROOM_FENCE_GATES);
    }

    public static MnBlockBuilder<WallBlock> wall(RegistryObject<? extends Block> original) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<WallBlock>(WallBlock::new, original).mineableWithPickaxe()).blockStateAndModel((states, block) -> states.wallBlock((Supplier)block, (Supplier)original))).blockItem((models, block) -> models.wallInventory(models.name(block), models.texture((Supplier)original)), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS)).tag(MnBlockTags.WALLS);
    }

    private static MnBlockBuilder<ButtonBlock> buttonInternal(RegistryObject<? extends Block> original, Supplier<BlockSetType> blockSetType, boolean stone) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<ButtonBlock>(p -> new ButtonBlock(p, (BlockSetType)blockSetType.get(), stone ? 20 : 30, !stone)).mapColor(stone ? MapColor.f_283947_ : MapColor.f_283825_)).ignitedByLava(!stone)).instrument(stone ? NoteBlockInstrument.BASEDRUM : NoteBlockInstrument.BASS)).noCollision()).strength(0.5)).blockStateAndModel((states, block) -> states.buttonBlock((Supplier)block, states.texture((Supplier)original)))).blockItem((models, block) -> models.buttonInventory(models.name(block), models.texture((Supplier)original)), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<ButtonBlock> stoneButton(RegistryObject<? extends Block> original, Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.buttonInternal(original, blockSetType, true).mineableWithPickaxe()).tag(MnBlockTags.BUTTONS);
    }

    private static MnBlockBuilder<ButtonBlock> woodButtonInternal(RegistryObject<? extends Block> original, Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)BlockBuilderPresets.buttonInternal(original, blockSetType, false).mineableWithAxe();
    }

    public static MnBlockBuilder<ButtonBlock> woodButton(RegistryObject<? extends Block> original, Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodButtonInternal(original, blockSetType).tag(MnBlockTags.WOODEN_BUTTONS);
    }

    public static MnBlockBuilder<ButtonBlock> shroomButton(RegistryObject<? extends Block> original, Supplier<BlockSetType> blockSetType) {
        return (MnBlockBuilder)BlockBuilderPresets.woodButtonInternal(original, blockSetType).tag(MnBlockTags.SHROOM_BUTTONS);
    }

    private static MnBlockBuilder<LadderBlock> ladderInternal() {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<LadderBlock>(LadderBlock::new).pushReaction(PushReaction.DESTROY)).strength(0.4)).noOcclusion()).sound(SoundType.f_56748_)).mineableWithAxe()).blockStateAndModel((states, block) -> states.horizontalBlock((Supplier)block, (ModelFile)((MnBlockModelProvider)states.models()).ladder((LadderBlock)block.get())))).blockItem((models, block) -> models.generated(block), (Supplier)MnCreativeModeTabs.FUNCTIONAL_BLOCKS);
    }

    public static MnBlockBuilder<LadderBlock> woodLadder() {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.ladderInternal().mineableWithAxe()).tag(MnBlockTags.WOODEN_LADDERS);
    }

    public static MnBlockBuilder<LadderBlock> shroomLadder() {
        return (MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.ladderInternal().mineableWithAxe()).tag(MnBlockTags.SHROOM_LADDERS);
    }

    private static MnBlockBuilder<TrapDoorBlock> trapdoorInternal(Supplier<BlockSetType> blockSetType, boolean orientable) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<TrapDoorBlock>(p -> new TrapDoorBlock(p, (BlockSetType)blockSetType.get())).noOcclusion()).isValidSpawn(false)).blockStateAndModel((states, block) -> states.trapdoorBlock((Supplier)block, states.texture((Supplier)block), orientable, ICrypticModelProvider.RenderType.CUTOUT))).blockItem((models, block) -> models.inherit(block, b -> models.texture((ItemLike)b, "bottom")), (Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    private static MnBlockBuilder<TrapDoorBlock> woodTrapdoorInternal(Supplier<BlockSetType> blockSetType, boolean orientable) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.trapdoorInternal(blockSetType, orientable).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).strength(3)).mineableWithAxe();
    }

    public static MnBlockBuilder<TrapDoorBlock> woodTrapdoor(Supplier<BlockSetType> blockSetType, boolean orientable) {
        return (MnBlockBuilder)BlockBuilderPresets.woodTrapdoorInternal(blockSetType, orientable).tag(MnBlockTags.WOODEN_TRAPDOORS);
    }

    public static MnBlockBuilder<TrapDoorBlock> shroomTrapdoor(Supplier<BlockSetType> blockSetType, boolean orientable) {
        return (MnBlockBuilder)BlockBuilderPresets.woodTrapdoorInternal(blockSetType, orientable).tag(MnBlockTags.SHROOM_TRAPDOORS);
    }

    public static MnBlockBuilder<TrapDoorBlock> metalTrapdoor(Supplier<BlockSetType> blockSetType, boolean orientable) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.trapdoorInternal(blockSetType, orientable).mapColor(MapColor.f_283906_)).strength(5)).requiresCorrectToolForDrops()).mineableWithPickaxe()).needsTier((Tier)Tiers.IRON)).tag(MnBlockTags.METAL_TRAPDOORS);
    }

    public static MnBlockBuilder<? extends WallSignBlock> wallSign(final Supplier<? extends SignItem> item, Supplier<WoodType> woodType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<3>(p -> new WallSignBlock((BlockBehaviour.Properties)p, (WoodType)woodType.get()){

            public Item m_5456_() {
                return (Item)item.get();
            }

            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return ((BlockEntityType)MnBlockEntities.SIGN.get()).m_155264_(pos, state);
            }
        }).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).noCollision()).strength(1)).tag(MnBlockTags.WALL_SIGNS);
    }

    public static MnBlockBuilder<? extends AbstractStandingSignBlock.Basic> standingSign(final Supplier<? extends SignItem> item, Supplier<WoodType> woodType, Supplier<? extends WallSignBlock> wallSign, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<4>(p -> new AbstractStandingSignBlock.Basic((BlockBehaviour.Properties)p, (WoodType)woodType.get(), wallSign){

            public Item m_5456_() {
                return (Item)item.get();
            }

            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return ((BlockEntityType)MnBlockEntities.SIGN.get()).m_155264_(pos, state);
            }
        }).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).noCollision()).strength(1)).blockStateAndModel((states, block) -> states.signBlock((Supplier)block, wallSign, texture).standing())).tag(MnBlockTags.STANDING_SIGNS);
    }

    public static MnBlockBuilder<? extends WallHangingSignBlock> wallHangingSign(final Supplier<? extends HangingSignItem> item, Supplier<WoodType> woodType) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<5>(p -> new WallHangingSignBlock((BlockBehaviour.Properties)p, (WoodType)woodType.get()){

            public Item m_5456_() {
                return (Item)item.get();
            }

            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return ((BlockEntityType)MnBlockEntities.HANGING_SIGN.get()).m_155264_(pos, state);
            }
        }).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).noCollision()).strength(1)).tag(MnBlockTags.WALL_HANGING_SIGNS);
    }

    public static MnBlockBuilder<? extends AbstractCeilingHangingSignBlock.Basic> ceilingHangingSign(final Supplier<? extends HangingSignItem> item, Supplier<WoodType> woodType, Supplier<? extends WallHangingSignBlock> wallSign, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<6>(p -> new AbstractCeilingHangingSignBlock.Basic((BlockBehaviour.Properties)p, (WoodType)woodType.get(), wallSign){

            public Item m_5456_() {
                return (Item)item.get();
            }

            public BlockEntity m_142194_(BlockPos pos, BlockState state) {
                return ((BlockEntityType)MnBlockEntities.HANGING_SIGN.get()).m_155264_(pos, state);
            }
        }).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).noCollision()).strength(1)).blockStateAndModel((states, block) -> states.hangingSignBlock((Supplier)block, wallSign, texture).standing())).tag(MnBlockTags.CEILING_HANGING_SIGNS);
    }

    private static MnBlockBuilder<PressurePlateBlock> pressurePlateInternal(PressurePlateBlock.Sensitivity sensitivity, Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<PressurePlateBlock>(p -> new PressurePlateBlock(sensitivity, p, (BlockSetType)type.get())).noCollision()).strength(0.5)).blockStateAndModel((states, block) -> states.pressurePlateBlock((Supplier)block, texture))).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<PressurePlateBlock> stonePressurePlate(Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.pressurePlateInternal(PressurePlateBlock.Sensitivity.MOBS, type, texture).mapColor(MapColor.f_283947_)).instrument(NoteBlockInstrument.BASEDRUM)).requiresCorrectToolForDrops()).mineableWithPickaxe()).tag(MnBlockTags.STONE_PRESSURE_PLATES);
    }

    private static MnBlockBuilder<PressurePlateBlock> woodPressurePlateInternal(Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.pressurePlateInternal(PressurePlateBlock.Sensitivity.EVERYTHING, type, texture).mapColor(MapColor.f_283825_)).instrument(NoteBlockInstrument.BASS)).ignitedByLava()).mineableWithAxe();
    }

    public static MnBlockBuilder<PressurePlateBlock> woodPressurePlate(Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)BlockBuilderPresets.woodPressurePlateInternal(type, texture).tag(MnBlockTags.WOODEN_PRESSURE_PLATES);
    }

    public static MnBlockBuilder<PressurePlateBlock> shroomPressurePlate(Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)BlockBuilderPresets.woodPressurePlateInternal(type, texture).tag(MnBlockTags.SHROOM_PRESSURE_PLATES);
    }

    private static MnBlockBuilder<WeightedPressurePlateBlock> weightedPressurePlateInternal(int maxWeight, Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)new MnBlockBuilder<WeightedPressurePlateBlock>(p -> new WeightedPressurePlateBlock(maxWeight, p, (BlockSetType)type.get())).noCollision()).strength(0.5)).blockStateAndModel((states, block) -> states.weightedPressurePlateBlock((Supplier)block, texture))).blockItem((Supplier)MnCreativeModeTabs.BUILDING_BLOCKS);
    }

    public static MnBlockBuilder<WeightedPressurePlateBlock> metalWeightedPressurePlate(int maxWeight, Supplier<BlockSetType> type, Supplier<? extends Block> texture) {
        return (MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)((MnBlockBuilder)BlockBuilderPresets.weightedPressurePlateInternal(maxWeight, type, texture).mapColor(MapColor.f_283906_)).requiresCorrectToolForDrops()).mineableWithPickaxe()).tag(MnBlockTags.METAL_PRESSURE_PLATES);
    }
}

