/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.registry.MnNoises;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.midnight.common.world.gen.MidnightTerrainProvider;
import com.crypticmushroom.minecraft.midnight.common.world.gen.densityfunction.QuarterCircleDensityFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class MnNoiseRouterData {
    private static final DensityFunction ZERO = DensityFunctions.m_208263_();
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.m_208264_((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.m_208263_();
    private static final ResourceKey<DensityFunction> Y = MnNoiseRouterData.vanillaKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = MnNoiseRouterData.vanillaKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = MnNoiseRouterData.vanillaKey("shift_z");
    private static final ResourceKey<DensityFunction> LARGE_SHIFT_X = MnNoiseRouterData.key("large_shift_x");
    private static final ResourceKey<DensityFunction> LARGE_SHIFT_Z = MnNoiseRouterData.key("large_shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE = MnNoiseRouterData.key("base_3d_noise");
    private static final ResourceKey<DensityFunction> CONTINENTS = MnNoiseRouterData.key("continents");
    private static final ResourceKey<DensityFunction> CONTINENTS_FOLDED = MnNoiseRouterData.key("continents_folded");
    private static final ResourceKey<DensityFunction> EROSION = MnNoiseRouterData.key("erosion");
    private static final ResourceKey<DensityFunction> EROSION_FOLDED = MnNoiseRouterData.key("erosion_folded");
    private static final ResourceKey<DensityFunction> RIDGES = MnNoiseRouterData.key("ridges");
    private static final ResourceKey<DensityFunction> RIDGES_FOLDED = MnNoiseRouterData.key("ridges_folded");
    private static final ResourceKey<DensityFunction> OFFSET = MnNoiseRouterData.key("offset");
    private static final ResourceKey<DensityFunction> FACTOR = MnNoiseRouterData.key("factor");
    private static final ResourceKey<DensityFunction> DEPTH = MnNoiseRouterData.key("depth");
    private static final ResourceKey<DensityFunction> JAGGEDNESS = MnNoiseRouterData.key("jaggedness");
    private static final ResourceKey<DensityFunction> SLOPED_CHEESE = MnNoiseRouterData.key("sloped_cheese");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = MnNoiseRouterData.vanillaKey("overworld/caves/spaghetti_2d");
    private static final ResourceKey<DensityFunction> GREATER_CAVERNS_GRADIENT = MnNoiseRouterData.key("greater_caverns_gradient");

    private static ResourceKey<DensityFunction> key(String name) {
        return MnRegistry.DENSITY_FUNCTIONS.key(name);
    }

    private static ResourceKey<DensityFunction> vanillaKey(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257040_, (ResourceLocation)new ResourceLocation(id));
    }

    static void bootstrap(BootstapContext<DensityFunction> ctx) {
        HolderGetter noises = ctx.m_255420_(Registries.f_256865_);
        HolderGetter densityFunctions = ctx.m_255420_(Registries.f_257040_);
        Holder.Reference base3dNoiseHolder = ctx.m_255272_(BASE_3D_NOISE, (Object)BlendedNoise.m_230477_((double)0.25, (double)0.125, (double)80.0, (double)160.0, (double)8.0));
        DensityFunction shiftX = MnNoiseRouterData.getFunction((HolderGetter<DensityFunction>)densityFunctions, SHIFT_X);
        DensityFunction shiftZ = MnNoiseRouterData.getFunction((HolderGetter<DensityFunction>)densityFunctions, SHIFT_Z);
        DensityFunction largeShiftX = MnNoiseRouterData.registerAndWrap(ctx, LARGE_SHIFT_X, DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208366_(MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.LARGE_SHIFT))));
        DensityFunction largeShiftZ = MnNoiseRouterData.registerAndWrap(ctx, LARGE_SHIFT_Z, DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208378_(MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.LARGE_SHIFT))));
        DensityFunction continents = MnNoiseRouterData.registerAndWrap(ctx, CONTINENTS, DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)largeShiftX, (DensityFunction)largeShiftZ, (double)0.25, MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.CONTINENTALNESS))));
        Holder.Reference continentsFoldedHolder = ctx.m_255272_(CONTINENTS_FOLDED, (Object)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-1.0), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)2.0), (DensityFunction)continents.m_208229_())));
        DensityFunction erosion = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.EROSION)));
        Holder.Reference erosionHolder = ctx.m_255272_(EROSION, (Object)erosion);
        Holder.Reference erosionFoldedHolder = ctx.m_255272_(EROSION_FOLDED, (Object)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-1.0), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)2.0), (DensityFunction)erosion.m_208229_())));
        DensityFunction ridges = DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.RIDGE)));
        Holder.Reference weirdnessHolder = ctx.m_255272_(RIDGES, (Object)ridges);
        Holder.Reference ridgesFoldedHolder = ctx.m_255272_(RIDGES_FOLDED, (Object)MnNoiseRouterData.peaksAndValleys(ridges));
        DensityFunction jaggedNoise = DensityFunctions.m_208368_(MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.JAGGED), (double)1500.0, (double)0.0);
        DensityFunctions.Spline.Coordinate continentsCoord = new DensityFunctions.Spline.Coordinate((Holder)continentsFoldedHolder);
        DensityFunctions.Spline.Coordinate erosionCoord = new DensityFunctions.Spline.Coordinate((Holder)erosionHolder);
        DensityFunctions.Spline.Coordinate erosionFoldedCoord = new DensityFunctions.Spline.Coordinate((Holder)erosionFoldedHolder);
        DensityFunctions.Spline.Coordinate ridgesCoord = new DensityFunctions.Spline.Coordinate((Holder)ridgesFoldedHolder);
        DensityFunctions.Spline.Coordinate weirdnessCoord = new DensityFunctions.Spline.Coordinate((Holder)weirdnessHolder);
        DensityFunction offset = MnNoiseRouterData.registerAndWrap(ctx, OFFSET, MnNoiseRouterData.splineWithBlending(DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.50375f), (DensityFunction)DensityFunctions.m_224020_(MidnightTerrainProvider.offset(continentsCoord, erosionCoord, ridgesCoord, weirdnessCoord))), DensityFunctions.m_208372_()));
        DensityFunction factor = MnNoiseRouterData.registerAndWrap(ctx, FACTOR, MnNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_(MidnightTerrainProvider.factor(continentsCoord, erosionCoord, ridgesCoord)), BLENDING_FACTOR));
        DensityFunction depthGradient = MnNoiseRouterData.registerAndWrap(ctx, DEPTH, DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)offset));
        DensityFunction jaggedness = MnNoiseRouterData.registerAndWrap(ctx, JAGGEDNESS, MnNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_(MidnightTerrainProvider.jaggedness(continentsCoord, erosionFoldedCoord, ridgesCoord)), BLENDING_JAGGEDNESS));
        jaggedness = DensityFunctions.m_208363_((DensityFunction)jaggedness, (DensityFunction)jaggedNoise.m_208232_());
        DensityFunction noiseGradient = MnNoiseRouterData.noiseGradientDensity(factor, DensityFunctions.m_208293_((DensityFunction)depthGradient, (DensityFunction)jaggedness));
        ctx.m_255272_(SLOPED_CHEESE, (Object)DensityFunctions.m_208293_((DensityFunction)noiseGradient, (DensityFunction)new DensityFunctions.HolderHolder((Holder)base3dNoiseHolder)));
        DensityFunction cavernYModifier = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)1.0, MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.GREATER_CAVERNS_Y_MODULATOR));
        double yModifierScale = 1.0;
        DensityFunction lowerGradient = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)-36, (double)2.0, (double)-1.0), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)cavernYModifier, (DensityFunction)DensityFunctions.m_208264_((double)yModifierScale)));
        DensityFunction upperGradient = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-36, (int)24, (double)-1.0, (double)3.0), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)cavernYModifier, (DensityFunction)DensityFunctions.m_208264_((double)(-yModifierScale))));
        DensityFunction gradientModifier = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)0.2), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.0), (DensityFunction)DensityFunctions.m_208385_(MnNoiseRouterData.getNoise((HolderGetter<NormalNoise.NoiseParameters>)noises, MnNoises.GREATER_CAVERNS_GRADIENT_ADDITION))));
        ctx.m_255272_(GREATER_CAVERNS_GRADIENT, (Object)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208382_((DensityFunction)lowerGradient, (DensityFunction)upperGradient), (DensityFunction)gradientModifier));
    }

    private static DensityFunction registerAndWrap(BootstapContext<DensityFunction> context, ResourceKey<DensityFunction> key, DensityFunction densityFunction) {
        return new DensityFunctions.HolderHolder((Holder)context.m_255272_(key, (Object)densityFunction));
    }

    public static NoiseRouter create(HolderGetter<DensityFunction> densityFunctions, HolderGetter<NormalNoise.NoiseParameters> noises) {
        DensityFunction shiftX = MnNoiseRouterData.getFunction(densityFunctions, SHIFT_X);
        DensityFunction shiftZ = MnNoiseRouterData.getFunction(densityFunctions, SHIFT_Z);
        DensityFunction corruption = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, MnNoiseRouterData.getNoise(noises, (ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, MnNoiseRouterData.getNoise(noises, (ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_));
        DensityFunction erosion = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, MnNoiseRouterData.getNoise(noises, (ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189280_));
        DensityFunction factor = MnNoiseRouterData.getFunction(densityFunctions, FACTOR);
        DensityFunction depth = MnNoiseRouterData.getFunction(densityFunctions, DEPTH);
        DensityFunction factorDepthNoiseGradient = MnNoiseRouterData.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)factor), depth);
        DensityFunction terrain = MnNoiseRouterData.getFunction(densityFunctions, SLOPED_CHEESE);
        DensityFunction pillars = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)2.0), (DensityFunction)DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)1.0, MnNoiseRouterData.getNoise(noises, MnNoises.GREATER_CAVERNS_PILLAR)));
        DensityFunction greaterCavernsGradient = MnNoiseRouterData.getFunction(densityFunctions, GREATER_CAVERNS_GRADIENT);
        greaterCavernsGradient = new QuarterCircleDensityFunction(greaterCavernsGradient);
        DensityFunction greaterCaverns = DensityFunctions.m_208293_((DensityFunction)greaterCavernsGradient, (DensityFunction)pillars);
        DensityFunctions.Spline.Coordinate continentsCoord = new DensityFunctions.Spline.Coordinate(MnNoiseRouterData.getFunctionHolder(densityFunctions, CONTINENTS_FOLDED));
        DensityFunction greaterCavernContSpline = DensityFunctions.m_224020_((CubicSpline)CubicSpline.m_184252_((ToFloatFunction)continentsCoord).m_216114_(-0.03f, 3.0f).m_216114_(0.0f, 0.0f).m_184297_());
        DensityFunction greaterCavernsWithCont = DensityFunctions.m_208293_((DensityFunction)greaterCaverns, (DensityFunction)greaterCavernContSpline);
        DensityFunction spaghettiCavesContSpline = DensityFunctions.m_224020_((CubicSpline)CubicSpline.m_184252_((ToFloatFunction)continentsCoord).m_216114_(-0.05f, 0.0f).m_216114_(-0.03f, 2.0f).m_184297_());
        DensityFunction spaghettiCavesWithErosion = DensityFunctions.m_208293_((DensityFunction)MnNoiseRouterData.getFunction(densityFunctions, SPAGHETTI_2D), (DensityFunction)spaghettiCavesContSpline);
        DensityFunction caves = DensityFunctions.m_208375_((DensityFunction)greaterCavernsWithCont, (DensityFunction)spaghettiCavesWithErosion);
        DensityFunction almostFinalWithCaves = DensityFunctions.m_208375_((DensityFunction)terrain, (DensityFunction)caves);
        DensityFunction finalDensity = MnNoiseRouterData.postProcess(MnNoiseRouterData.slide(almostFinalWithCaves));
        return new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), corruption, vegetation, MnNoiseRouterData.getFunction(densityFunctions, CONTINENTS_FOLDED), MnNoiseRouterData.getFunction(densityFunctions, EROSION), depth, MnNoiseRouterData.getFunction(densityFunctions, RIDGES), MnNoiseRouterData.slide(DensityFunctions.m_208293_((DensityFunction)factorDepthNoiseGradient, (DensityFunction)DensityFunctions.m_208264_((double)-0.703125)).m_208220_(-64.0, 64.0)), finalDensity, DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_());
    }

    private static DensityFunction postProcess(DensityFunction p_224493_) {
        DensityFunction densityfunction = DensityFunctions.m_208389_((DensityFunction)p_224493_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)densityfunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    private static DensityFunction slide(DensityFunction function) {
        return MnNoiseRouterData.slide(function, -64, 384, 80, 64, -0.078125, 0, 24, 0.1171875);
    }

    private static DensityFunction slide(DensityFunction p_224444_, int p_224445_, int p_224446_, int p_224447_, int p_224448_, double p_224449_, int p_224450_, int p_224451_, double p_224452_) {
        DensityFunction densityfunction1 = DensityFunctions.m_208266_((int)(p_224445_ + p_224446_ - p_224447_), (int)(p_224445_ + p_224446_ - p_224448_), (double)1.0, (double)0.0);
        DensityFunction $$9 = DensityFunctions.m_224030_((DensityFunction)densityfunction1, (double)p_224449_, (DensityFunction)p_224444_);
        DensityFunction densityfunction2 = DensityFunctions.m_208266_((int)(p_224445_ + p_224450_), (int)(p_224445_ + p_224451_), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)densityfunction2, (double)p_224452_, (DensityFunction)$$9);
    }

    private static DensityFunction peaksAndValleys(DensityFunction p_224438_) {
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)p_224438_.m_208229_(), (DensityFunction)DensityFunctions.m_208264_((double)-0.6666666666666666)).m_208229_(), (DensityFunction)DensityFunctions.m_208264_((double)-0.3333333333333333)), (DensityFunction)DensityFunctions.m_208264_((double)-3.0));
    }

    private static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.m_208301_((DensityFunction)DensityFunctions.m_208360_(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)densityfunction));
    }

    private static DensityFunction getFunction(HolderGetter<DensityFunction> reg, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder((Holder)reg.m_255043_(key));
    }

    private static Holder<DensityFunction> getFunctionHolder(HolderGetter<DensityFunction> reg, ResourceKey<DensityFunction> key) {
        return reg.m_255043_(key);
    }

    private static Holder<NormalNoise.NoiseParameters> getNoise(HolderGetter<NormalNoise.NoiseParameters> reg, ResourceKey<NormalNoise.NoiseParameters> key) {
        return reg.m_255043_(key);
    }
}

