/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnNoiseRouterData;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.midnight.common.world.biome.MnBiomeMapBuilder;
import com.crypticmushroom.minecraft.midnight.common.world.gen.MnChunkGenerator;
import com.crypticmushroom.minecraft.midnight.common.world.gen.MnSurfaceRuleData;
import com.crypticmushroom.minecraft.registry.builder.minecraft.DimensionTypeBuilder;
import com.crypticmushroom.minecraft.registry.builder.minecraft.NoiseGeneratorSettingsBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.Nullable;

public final class MnDimensions {
    private static final Collection<AbstractDimension> ALL = new HashSet<AbstractDimension>();
    public static final AbstractDimension THE_MIDNIGHT = new AbstractDimension("the_midnight", new DimensionTypeBuilder().fixedTime(18000L).hasSkyLight(true).hasCeiling(false).ultraWarm(false).natural(false).coordinateScale(1.0).bedWorks(false).respawnAnchorWorks(false).minY(-64).height(384).logicalHeight(384).infiniburn(BlockTags.f_13058_).effectsLocation("midnight").ambientLight(0.0f).piglinSafe(false).hasRaids(false).monsterSpawnLightTest((IntProvider)ConstantInt.m_146483_((int)7)).monsterSpawnBlockLightLimit(10), new NoiseGeneratorSettingsBuilder().minY(Integer.valueOf(-64)).height(Integer.valueOf(384)).noiseSizeHorizontal(Integer.valueOf(1)).noiseSizeVertical(Integer.valueOf(2)).defaultBlock(MnBlocks.NIGHTSTONE).defaultFluid(() -> (LiquidBlock)Blocks.f_49990_).noiseRouter(ctx -> MnNoiseRouterData.create((HolderGetter<DensityFunction>)ctx.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)ctx.m_255420_(Registries.f_256865_))).surfaceRule(MnSurfaceRuleData::create).seaLevel(Integer.valueOf(63)).disableMobGeneration(Boolean.valueOf(false)).aquifersEnabled(Boolean.valueOf(true)).oreVeinsEnabled(Boolean.valueOf(false)).useLegacyRandomSource(Boolean.valueOf(false))){

        @Override
        public ChunkGenerator createChunkGenerator(HolderGetter<Biome> biomeReg, HolderGetter<NoiseGeneratorSettings> settingsReg) {
            return new MnChunkGenerator((BiomeSource)this.makeBiomeSource(biomeReg), (Holder<NoiseGeneratorSettings>)settingsReg.m_255043_(this.noiseGenSettings()));
        }

        private MultiNoiseBiomeSource makeBiomeSource(HolderGetter<Biome> registry) {
            ImmutableList.Builder builder = ImmutableList.builder();
            new MnBiomeMapBuilder().addBiomes(pair -> builder.add((Object)pair.mapSecond(arg_0 -> ((HolderGetter)registry).m_255043_(arg_0))));
            return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList((List)builder.build()));
        }
    };

    private static ResourceKey<LevelStem> key(String name) {
        return MnRegistry.LEVEL_STEMS.key(name);
    }

    static void bootstrap(BootstapContext<LevelStem> bootstrap) {
        ALL.forEach(dimension -> bootstrap.m_255272_(dimension.levelStem, (Object)dimension.create(bootstrap)));
    }

    public static abstract class AbstractDimension
    implements Supplier<ResourceKey<Level>> {
        private final ResourceKey<LevelStem> levelStem;
        private final ResourceKey<Level> level;
        private final ResourceKey<DimensionType> dimensionType;
        private final ResourceKey<NoiseGeneratorSettings> noiseGenSettings;
        public final ResourceLocation id;

        protected AbstractDimension(String name, DimensionTypeBuilder<?> dimensionTypeBuilder, NoiseGeneratorSettingsBuilder<?> noiseGenSettingsBuilder) {
            this.levelStem = MnDimensions.key(name);
            this.level = Registries.m_257551_(this.levelStem);
            this.dimensionType = ((DimensionTypeBuilder)dimensionTypeBuilder.id(name)).build();
            this.noiseGenSettings = ((NoiseGeneratorSettingsBuilder)noiseGenSettingsBuilder.id(name)).build();
            this.id = this.levelStem.m_135782_();
            ALL.add(this);
        }

        public LevelStem create(BootstapContext<LevelStem> ctx) {
            Holder.Reference dimensionType = ctx.m_255420_(Registries.f_256787_).m_255043_(this.dimensionType);
            ChunkGenerator chunkGenerator = this.createChunkGenerator((HolderGetter<Biome>)ctx.m_255420_(Registries.f_256952_), (HolderGetter<NoiseGeneratorSettings>)ctx.m_255420_(Registries.f_256932_));
            return new LevelStem((Holder)dimensionType, chunkGenerator);
        }

        @Override
        public final ResourceKey<Level> get() {
            return this.level;
        }

        public final ResourceKey<LevelStem> levelStem() {
            return this.levelStem;
        }

        public ResourceKey<DimensionType> dimensionType() {
            return this.dimensionType;
        }

        public ResourceKey<NoiseGeneratorSettings> noiseGenSettings() {
            return this.noiseGenSettings;
        }

        public final boolean is(@Nullable Level level) {
            return level != null && level.m_46472_().equals(this.get());
        }

        public final ServerLevel get(MinecraftServer server) {
            return server.m_129880_(this.get());
        }

        protected abstract ChunkGenerator createChunkGenerator(HolderGetter<Biome> var1, HolderGetter<NoiseGeneratorSettings> var2);
    }
}

