/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.registry;

import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Nightshade;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class MnBrainUtil {
    public static <E extends LivingEntity> ExtendedBehaviour<E> healWithCooldown(E entity, int amt, int cooldown, Predicate<E> startIf) {
        return new CustomBehaviour(e -> e.m_5634_((float)amt)).startCondition(startIf).cooldownFor(e -> cooldown);
    }

    public static <E extends LivingEntity> ExtendedBehaviour<E> riftBasedHealOrHurt(E entity, Predicate<E> hurtPredicate) {
        return new CustomBehaviour(e -> {
            if (BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get())) && !((List)BrainUtils.getMemory((LivingEntity)e, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()))).isEmpty()) {
                e.m_5634_(1.0f);
            } else if (hurtPredicate.test(e)) {
                e.m_6469_(e.m_9236_().m_269111_().m_269341_(), 2.0f);
            }
        }).cooldownFor(e -> 40);
    }

    public static <E extends LivingEntity> ExtendedBehaviour<E> ejectPassengers(E entity) {
        return new CustomBehaviour(e -> e.m_20153_()).startCondition(Entity::m_20160_);
    }

    public static <E extends Nightshade> ExtendedBehaviour<E> updateAngry(E entity) {
        return new CustomBehaviour(e -> {
            if (e.isAngry()) {
                e.setAngry(false);
            }
        }).startCondition(e -> BrainUtils.getTargetOfEntity((LivingEntity)e) == null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <E extends LivingEntity> boolean attackTargetInvalid(E entity, LivingEntity target) {
        if (target instanceof Player) {
            Player pl = (Player)target;
            if (pl.m_150110_().f_35934_) return true;
        }
        if (!(entity.m_20238_(target.m_20182_()) > Math.pow(entity.m_21133_(Attributes.f_22277_), 2.0))) return false;
        return true;
    }
}

