/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.recipe;

import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRecipeSerializers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SmithingTrimRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ViriluxUpgradeSmithingRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public ViriluxUpgradeSmithingRecipe(ResourceLocation id, Ingredient template, Ingredient base, Ingredient addition) {
        this.id = id;
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public static SmithingTrimRecipeBuilder builder(Ingredient template, Ingredient base, Ingredient addition, RecipeCategory category) {
        return new SmithingTrimRecipeBuilder((RecipeSerializer)MnRecipeSerializers.NBT_SMITHING.get(), category, template, base, addition);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack base = container.m_8020_(1);
        if (this.base.test(base)) {
            ItemStack result = base.m_41777_();
            result.m_41764_(1);
            CompoundTag tag = result.m_41784_();
            tag.m_128405_("luxed", 1);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)MnItems.NAGRILITE_SWORD.get());
    }

    public boolean m_142505_() {
        return Stream.of(this.template, this.base, this.addition).anyMatch(Ingredient::m_43947_);
    }

    public boolean m_5818_(Container container, Level level) {
        return this.template.test(container.m_8020_(0)) && this.base.test(container.m_8020_(1)) && this.addition.test(container.m_8020_(2));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_266166_(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean m_266253_(ItemStack stack) {
        return this.addition.test(stack);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MnRecipeSerializers.NBT_SMITHING.get();
    }

    public static class Serializer
    implements RecipeSerializer<ViriluxUpgradeSmithingRecipe> {
        public ViriluxUpgradeSmithingRecipe fromJson(ResourceLocation id, JsonObject serializedRecipe) {
            Ingredient template = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"template"));
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"addition"));
            return new ViriluxUpgradeSmithingRecipe(id, template, base, addition);
        }

        @Nullable
        public ViriluxUpgradeSmithingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new ViriluxUpgradeSmithingRecipe(id, template, base, addition);
        }

        public void toNetwork(FriendlyByteBuf buffer, ViriluxUpgradeSmithingRecipe recipe) {
            recipe.template.m_43923_(buffer);
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
        }
    }
}

