/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.network;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.network.MnPacket;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnEntityPacket;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnLivingEntityPacket;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnPlayerPacket;
import com.crypticmushroom.minecraft.midnight.common.network.effects.MnBiomeEffectsPacket;
import com.crypticmushroom.minecraft.midnight.common.network.effects.MnLocalAmbienceSoundPacket;
import com.crypticmushroom.minecraft.midnight.common.network.level.RiftBridgeMessage;
import com.crypticmushroom.minecraft.midnight.common.network.level.RockshroomAttackPacket;
import com.crypticmushroom.minecraft.midnight.common.network.level.TendrilweedGrowPacket;
import com.crypticmushroom.minecraft.midnight.common.network.level.VioleafHealPacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MnNetwork {
    public static final Marker NETWORK_MARKER = MarkerManager.getMarker((String)"NETWORK");
    public static final String NET_PROTOCOL = "3";
    public static final SimpleChannel CHANNEL;

    private static SimpleChannel createNetwork(ResourceLocation id) {
        Midnight.LOGGER.debug(NETWORK_MARKER, "Creating network channel with id {}", (Object)id);
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)id).networkProtocolVersion(() -> NET_PROTOCOL).clientAcceptedVersions(NET_PROTOCOL::equals).serverAcceptedVersions(NET_PROTOCOL::equals).simpleChannel();
    }

    private static <T extends MnPacket> void register(int id, NetworkDirection direction, Class<T> type, Function<FriendlyByteBuf, T> read) {
        Midnight.LOGGER.debug(NETWORK_MARKER, "Registering new packet of id {} and type {}", (Object)id, (Object)type.getSimpleName());
        CHANNEL.messageBuilder(type, id, direction).encoder(MnPacket::write).decoder(read).consumerMainThread((pkt, ctxSup) -> pkt.handle((NetworkEvent.Context)ctxSup.get())).add();
    }

    static {
        Midnight.LOGGER.debug(NETWORK_MARKER, "Initializing Midnight network protocol");
        CHANNEL = MnNetwork.createNetwork(Midnight.id("net"));
        MnNetwork.register(0, NetworkDirection.PLAY_TO_CLIENT, RockshroomAttackPacket.class, buffer -> RockshroomAttackPacket.read(buffer));
        MnNetwork.register(1, NetworkDirection.PLAY_TO_CLIENT, VioleafHealPacket.class, buffer -> VioleafHealPacket.read(buffer));
        MnNetwork.register(2, NetworkDirection.PLAY_TO_CLIENT, TendrilweedGrowPacket.class, buffer -> TendrilweedGrowPacket.read(buffer));
        MnNetwork.register(3, NetworkDirection.PLAY_TO_CLIENT, MnEntityPacket.class, buffer -> MnEntityPacket.read(buffer));
        MnNetwork.register(3, NetworkDirection.PLAY_TO_CLIENT, MnLivingEntityPacket.class, buffer -> MnLivingEntityPacket.read(buffer));
        MnNetwork.register(3, NetworkDirection.PLAY_TO_CLIENT, MnPlayerPacket.class, buffer -> MnPlayerPacket.read(buffer));
        MnNetwork.register(4, NetworkDirection.PLAY_TO_CLIENT, RiftBridgeMessage.State.class, buffer -> RiftBridgeMessage.State.read(buffer));
        MnNetwork.register(5, NetworkDirection.PLAY_TO_CLIENT, RiftBridgeMessage.Create.class, buffer -> RiftBridgeMessage.Create.read(buffer));
        MnNetwork.register(6, NetworkDirection.PLAY_TO_CLIENT, RiftBridgeMessage.Remove.class, buffer -> RiftBridgeMessage.Remove.read(buffer));
        MnNetwork.register(7, NetworkDirection.PLAY_TO_CLIENT, MnLocalAmbienceSoundPacket.class, buffer -> MnLocalAmbienceSoundPacket.read(buffer));
        MnNetwork.register(8, NetworkDirection.PLAY_TO_CLIENT, MnBiomeEffectsPacket.class, buffer -> MnBiomeEffectsPacket.read(buffer));
    }
}

