/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.item;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.item.util.IMnThrowableProjectileItemEntity;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ThrowableItem<E extends Projectile>
extends Item {
    private final Supplier<? extends SoundEvent> throwSound;
    private final BiFunction<? super Player, ? super Level, E> throwableFactory;

    public ThrowableItem(Item.Properties properties, Supplier<? extends SoundEvent> throwSound, BiFunction<? super Player, ? super Level, E> throwableFactory) {
        super(properties);
        this.throwSound = throwSound;
        this.throwableFactory = throwableFactory;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), this.getThrowSoundEvent(), SoundSource.PLAYERS, 0.5f, 0.4f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
        if (!level.f_46443_) {
            E entity = this.createProjectile(player, level, stack);
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
            level.m_7967_(entity);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MnCriteriaTriggers.ITEM_PROJECTILE_THROW.trigger(serverPlayer, stack);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    protected SoundEvent getThrowSoundEvent() {
        return this.throwSound.get();
    }

    protected E createProjectile(Player player, Level level) {
        return (E)((Projectile)this.throwableFactory.apply((Player)player, (Level)level));
    }

    protected E createProjectile(Player player, Level level, ItemStack itemStack) {
        E projectile = this.createProjectile(player, level);
        itemStack.m_41784_().m_128379_("MnProjectileThrown", true);
        ((IMnThrowableProjectileItemEntity)projectile).setProjectileItemStack(itemStack);
        return projectile;
    }
}

