/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.item;

import com.crypticmushroom.minecraft.midnight.common.entity.projectile.ThrownBladeloop;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BladeloopItem
extends TieredItem
implements Vanishable {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public BladeloopItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, properties);
        this.attackDamage = (float)attackDamageModifier + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int timeCharged = this.m_8105_(stack) - timeLeft;
            if (timeCharged >= 4) {
                if (!level.f_46443_) {
                    stack.m_41622_(1, (LivingEntity)player, contextEntity -> contextEntity.m_21190_(livingEntity.m_7655_()));
                    ThrownBladeloop bladeloop = new ThrownBladeloop(level, (LivingEntity)player, stack, livingEntity.m_7655_() == InteractionHand.OFF_HAND);
                    float velocity = 1.3f;
                    float soundpitch = 0.6f;
                    if (timeCharged >= 10) {
                        bladeloop.setVertical();
                        velocity = 2.0f;
                        soundpitch = 0.5f;
                    }
                    bladeloop.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, velocity, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        bladeloop.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.m_7967_((Entity)bladeloop);
                    level.m_6269_((Player)null, (Entity)player, (SoundEvent)MnSoundEvents.ENTITY_BLADESHROOM_CAP_SHOOT.get(), SoundSource.PLAYERS, 1.0f, soundpitch);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(stack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, contextEntity -> contextEntity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)level, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, contextEntity -> contextEntity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }
}

