/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.rift;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.particle.RiftParticleSystem;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.MnLivingEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.IMnPreventsSleep;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.LegacyRifter;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.INativeRiftTraveler;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftAttachment;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftBridge;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import com.crypticmushroom.minecraft.midnight.common.world.dimension.IMnTeleporter;
import com.crypticmushroom.minecraft.midnight.common.world.manager.RiftBridgeManager;
import com.crypticmushroom.minecraft.midnight.data.i18n.MnI18n;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.awt.geom.Point2D;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class Rift
extends Entity
implements IEntityAdditionalSpawnData,
IMnPreventsSleep,
IMnTeleporter {
    public static final int OPEN_TIME = 20;
    public static final int CLOSE_SPEED = 2;
    public static final int CLOSE_TIME = 10;
    public static final int UNSTABLE_TIME = 110;
    public static final int LIFETIME = 4000;
    public static final float PULL_RADIUS = 8.0f;
    public static final float PULL_INTENSITY = 5.0f;
    public static final double MAX_PULL_VELOCITY = 1.2;
    protected static final Component BED_SLEEPING_PROBLEM_REASON = MnI18n.component("block.minecraft.bed.midnight.rift", "You may not rest now; there is an evil presence nearby", new Object[0]);
    public final Geometry geometry = new Geometry();
    private RiftBridge bridge;
    private RiftParticleSystem particleSystem = null;
    private boolean wasStable = true;
    private int spawnedRifters = 0;
    private int failedSpawn = 0;
    private boolean invalid;

    public Rift(EntityType<? extends Rift> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        if (level.f_46443_) {
            // empty if block
        }
    }

    public Rift(Level level) {
        this((EntityType<? extends Rift>)((EntityType)MnEntityTypes.RIFT.get()), level);
    }

    protected void m_8097_() {
    }

    @Override
    public Pair<Player.BedSleepingProblem, Component> getSleepPreventReason(ServerPlayer player) {
        return Pair.of((Object)Player.BedSleepingProblem.OTHER_PROBLEM, (Object)BED_SLEEPING_PROBLEM_REASON);
    }

    public void m_8119_() {
        if (this.invalid) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (this.m_6060_()) {
            this.m_20095_();
        }
        RiftBridge bridge = this.getBridge();
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (!bridge.exists) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (!MnDimensions.THE_MIDNIGHT.is(this.m_9236_())) {
                this.updateOverworldBehavior();
            }
            if (bridge.open.getTimer() >= 20 && !this.wasUsed()) {
                this.teleportEntities();
            }
            if (this.wasStable && bridge.unstable.get()) {
                this.m_5496_((SoundEvent)MnSoundEvents.ENTITY_RIFT_UNSTABLE.get(), 0.5f, 0.85f);
                this.wasStable = false;
            }
        } else if (this.particleSystem != null) {
            this.particleSystem.updateParticles();
        }
    }

    public void acceptBridge(RiftBridge bridge) {
        this.bridge = bridge;
        this.bridge.accept(this);
    }

    private void updateOverworldBehavior() {
        if (this.m_9236_().m_46461_() || this.m_9236_().m_7146_(this.m_20183_()) > 5) {
            this.getBridge().unstable.set(true);
        }
        if (this.isUnstable() && !this.wasUsed()) {
            this.pullEntities();
        }
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46134_) && !this.isUnstable() && this.spawnedRifters < 2 && this.m_9236_().f_46441_.m_188503_(1000) == 0) {
            if (this.trySpawnRifter()) {
                ++this.spawnedRifters;
                this.failedSpawn = 0;
            } else if (++this.failedSpawn > 5) {
                this.spawnedRifters = 2;
            }
        }
    }

    private boolean trySpawnRifter() {
        float theta = this.m_9236_().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        float offsetX = -Mth.m_14031_((float)theta) * this.m_20205_() * 0.9f;
        float offsetZ = Mth.m_14089_((float)theta) * this.m_20205_() * 0.9f;
        boolean isHunter = this.f_19796_.m_188501_() < 0.01f;
        Mob mob = (Mob)((EntityType)(isHunter ? MnEntityTypes.HUNTER : MnEntityTypes.RIFTER).get()).m_20615_(this.m_9236_());
        if (mob instanceof LegacyRifter) {
            LegacyRifter rifter = (LegacyRifter)mob;
            rifter.setFromRift(true);
        }
        mob.m_19890_(this.m_20185_() + (double)offsetX, this.m_20186_(), this.m_20189_() + (double)offsetZ, MathUtil.toDegreesStrict(theta), 0.0f);
        if (mob.m_6914_((LevelReader)this.m_9236_())) {
            this.m_9236_().m_7967_((Entity)mob);
            if (isHunter) {
                this.spawnedRifters = 2;
            }
            return true;
        }
        return false;
    }

    private void pullEntities() {
        double pullIntensity = this.getPullIntensity();
        AABB pullBounds = this.m_20191_().m_82400_(8.0);
        List entities = this.m_9236_().m_45933_((Entity)this, pullBounds);
        for (Entity entity : entities) {
            if (entity instanceof Rift) continue;
            this.pullEntity(pullIntensity, entity);
        }
    }

    public void pullEntity(double pullIntensity, Entity entity) {
        double deltaZ;
        double deltaY;
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return;
        }
        double deltaX = this.m_20185_() - entity.m_20185_();
        double distanceSq = deltaX * deltaX + (deltaY = this.m_20186_() + (double)(this.m_20206_() / 2.0f) - (entity.m_20186_() + (double)(entity.m_20206_() / 2.0f))) * deltaY + (deltaZ = this.m_20189_() - entity.m_20189_()) * deltaZ;
        if (distanceSq > 0.0) {
            double distance = Math.sqrt(distanceSq);
            double intensity = Mth.m_14008_((double)(pullIntensity / distanceSq), (double)0.0, (double)1.0);
            double accX = deltaX / distance * intensity;
            double accY = deltaY / distance * intensity;
            double accZ = deltaZ / distance * intensity;
            Vec3 newMotion = entity.m_20184_().m_82520_(accX, accY, accZ);
            if (newMotion.m_82556_() > 1.44) {
                newMotion.m_82541_();
                newMotion.m_82490_(1.2);
            }
            entity.m_20256_(newMotion);
            entity.f_19789_ = 0.0f;
        }
    }

    public double getPullIntensity() {
        if (this.wasUsed() || this.isBridgeInvalid()) {
            return 0.0;
        }
        double baseIntensity = (double)this.getBridge().unstable.getTimer() / 110.0;
        return Math.pow(baseIntensity, 5.0) * 5.0;
    }

    private void teleportEntities() {
        AABB bounds = this.m_20191_().m_82377_(-0.4, 0.0, -0.4);
        List entities = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(LivingEntity.class), bounds, entity -> {
            Player player;
            return !entity.m_20159_() && (!(entity instanceof Player) || !(player = (Player)entity).m_5833_()) && MnLivingEntity.getIfPresent(entity, MnLivingEntity::canEnterRift, () -> false) != false;
        });
        for (TravelEntry entry : this.getRecursedTravelers(entities)) {
            LivingEntity entity2 = entry.entity();
            if (entity2 instanceof INativeRiftTraveler) {
                INativeRiftTraveler traveler = (INativeRiftTraveler)entity2;
                traveler.onEnterRift(this);
            }
            entity2.m_19877_();
            entry.travel(this);
        }
    }

    private Set<TravelEntry> getRecursedTravelers(List<LivingEntity> entities) {
        if (entities.isEmpty()) {
            return ImmutableSet.of();
        }
        HashSet<TravelEntry> recursedEntities = new HashSet<TravelEntry>();
        for (LivingEntity entity : entities) {
            if (entity instanceof INativeRiftTraveler) {
                INativeRiftTraveler traveler = (INativeRiftTraveler)entity;
                recursedEntities.add(traveler.createTravelEntry(this));
                recursedEntities.addAll(traveler.getAdditionalTravelers(this));
                continue;
            }
            recursedEntities.add(new TravelEntry(entity));
            for (Entity passenger : entity.m_146897_()) {
                if (!(passenger instanceof LivingEntity)) continue;
                LivingEntity livingPassenger = (LivingEntity)passenger;
                recursedEntities.add(new TravelEntry(livingPassenger));
            }
        }
        return recursedEntities;
    }

    public boolean isOpen() {
        return !this.isBridgeInvalid() && this.getBridge().open.get();
    }

    public boolean isUnstable() {
        return !this.isBridgeInvalid() && this.getBridge().unstable.get();
    }

    public boolean wasUsed() {
        return !this.isBridgeInvalid() && this.getBridge().used;
    }

    @Nullable
    public RiftParticleSystem getParticleSystem() {
        return this.particleSystem;
    }

    public boolean isBridgeInvalid() {
        return this.bridge == null;
    }

    public RiftBridge getBridge() {
        if (!this.m_9236_().f_46443_ && this.bridge == null) {
            this.bridge = this.createBridge();
        }
        return this.bridge;
    }

    private RiftBridge createBridge() {
        RiftBridgeManager.Server trackerHandler = RiftBridgeManager.Server.get();
        RiftAttachment attachment = new RiftAttachment(this.m_20183_(), this.m_146908_());
        RiftBridge bridge = trackerHandler.create(attachment);
        bridge.accept(this);
        trackerHandler.add(bridge);
        return bridge;
    }

    public ResourceKey<Level> getEndpointDimension() {
        return MnDimensions.THE_MIDNIGHT.is(this.m_9236_()) ? Level.f_46428_ : MnDimensions.THE_MIDNIGHT.get();
    }

    public boolean isEndpointLoaded() {
        RiftBridge bridge = this.getBridge();
        return bridge != null && bridge.isEndpointLoaded(this.getEndpointDimension());
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128405_("spawned_rifters", this.spawnedRifters);
        nbt.m_128405_("failed_spawn", this.failedSpawn);
        if (this.bridge != null) {
            nbt.m_128405_("bridge_id", this.bridge.getId());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.spawnedRifters = nbt.m_128451_("spawned_rifters");
        this.failedSpawn = nbt.m_128451_("failed_spawn");
        if (nbt.m_128441_("bridge_id")) {
            this.invalid = this.initBridge(nbt.m_128451_("bridge_id"));
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.invalid);
        if (!this.invalid) {
            RiftBridge bridge = this.getBridge();
            buffer.writeInt(bridge.getId());
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.invalid = buffer.readBoolean();
        if (!this.invalid) {
            this.initBridge(buffer.readInt());
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_().f_46443_) {
            // empty if block
        }
    }

    private boolean initBridge(int bridgeId) {
        RiftBridgeManager tracker = RiftBridgeManager.get((LevelReader)this.m_9236_());
        RiftBridge bridge = tracker.get(bridgeId);
        if (bridge == null) {
            if (this.m_9236_().f_46443_) {
                bridge = new RiftBridge(bridgeId, new RiftAttachment(this.m_20183_(), this.m_146908_()));
                tracker.add(bridge);
            } else {
                return true;
            }
        }
        this.acceptBridge(bridge);
        return false;
    }

    @Override
    public boolean canTeleport(Entity entity, ResourceKey<Level> dimension) {
        RiftBridge bridge = this.getBridge();
        if (bridge == null) {
            Midnight.LOGGER.error("Unable to teleport entity through rift! Bridge not present on rift {} for dimension {} with destination {}", (Object)this, (Object)this.m_9236_().m_46472_(), dimension);
            return false;
        }
        return IMnTeleporter.super.canTeleport(entity, dimension);
    }

    @Override
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        Rift endpoint;
        try {
            endpoint = this.bridge.computeEndpoint(this.getEndpointDimension());
            Objects.requireNonNull(endpoint);
        }
        catch (NullPointerException e) {
            String error = String.format("Unable to teleport entity through rift! Endpoint rift not present on rift %s for dimension %s with destination %s", this, this.m_9236_().m_46472_(), destLevel.m_46472_());
            throw new IllegalStateException(error, e);
        }
        return new PortalInfo(this.findPlacementPos(entity, endpoint), entity.m_20184_(), entity.m_146909_(), entity.m_146908_());
    }

    private Vec3 findPlacementPos(Entity entity, Rift endpoint) {
        float angle = MathUtil.toRadiansStrict(entity.m_146908_());
        float displacementX = -Mth.m_14031_((float)angle) * endpoint.m_20205_() / 2.0f;
        float displacementZ = Mth.m_14089_((float)angle) * endpoint.m_20205_() / 2.0f;
        Vec3 placementPos = new Vec3(endpoint.m_20185_() + (double)displacementX, endpoint.m_20186_() + 0.5, endpoint.m_20189_() + (double)displacementZ);
        if (!endpoint.m_9236_().m_186437_(entity, this.getEntityBoundAt(entity, placementPos))) {
            return placementPos;
        }
        BlockPos placementBlockPos = BlockPos.m_274561_((double)placementPos.f_82479_, (double)placementPos.f_82480_, (double)placementPos.f_82481_);
        BlockPos minPos = placementBlockPos.m_7918_(-2, -2, -2);
        BlockPos maxPos = placementBlockPos.m_7918_(2, 2, 2);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
            Vec3 originPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            AABB entityBound = this.getEntityBoundAt(entity, originPos);
            if (entityBound.m_82381_(endpoint.m_20191_()) || !endpoint.m_9236_().m_45772_(entityBound)) continue;
            return originPos;
        }
        int surface = endpoint.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, placementBlockPos.m_123341_(), placementBlockPos.m_123343_());
        return new Vec3(placementPos.f_82479_ + 0.5, (double)surface + 0.5, placementPos.f_82481_ + 0.5);
    }

    private AABB getEntityBoundAt(Entity entity, Vec3 pos) {
        float halfWidth = entity.m_20205_() / 2.0f;
        return new AABB(pos.f_82479_ - (double)halfWidth, pos.f_82480_, pos.f_82481_ - (double)halfWidth, pos.f_82479_ + (double)halfWidth, pos.f_82480_ + (double)entity.m_20206_(), pos.f_82481_ + (double)halfWidth);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 256.0) * d0;
    }

    @Deprecated
    public class Geometry {
        private static final int POINT_COUNT = 12;
        private static final float DISPLACEMENT_SCALE = 0.4f;

        public Point2D.Float[] computePath(float animation, float unstableAnimation, float time) {
            Point2D.Float[] ring = new Point2D.Float[12];
            float idleSpeed = 0.08f;
            float idleIntensity = 0.1f * animation * (unstableAnimation * 5.0f + 1.0f);
            float displacementAnimation = Math.min(2.0f * animation, 1.0f);
            float sizeX = Rift.this.m_20205_() / 2.0f * animation;
            float sizeY = Rift.this.m_20206_() / 2.0f * 0.5f * (animation + 1.0f);
            float tau = (float)Math.PI * 2;
            for (int i = 0; i < 12; ++i) {
                float angle = (float)i * tau / 12.0f;
                float idleAnimation = Mth.m_14031_((float)(time * idleSpeed + (float)(i * 10))) * idleIntensity;
                float displacement = Rift.this.m_9236_().f_46441_.m_188501_() * 2.0f - 1.0f + idleAnimation;
                float scaledDisplacement = displacement * 0.4f * displacementAnimation;
                float pointX = -Mth.m_14031_((float)angle) * (sizeX + scaledDisplacement);
                float pointY = Mth.m_14089_((float)angle) * (sizeY + scaledDisplacement);
                ring[i] = new Point2D.Float(pointX, pointY);
            }
            return ring;
        }
    }

    public record TravelEntry(LivingEntity entity) {
        public void travel(Rift rift) {
            MnLivingEntity.ifPresent(this.entity, e -> e.enterRift(rift));
        }
    }

    public static class Reference {
        private UUID entityId;
        private ResourceKey<Level> dimension;
        @Nullable
        private WeakReference<Rift> rift;

        public void set(Rift rift) {
            this.rift = new WeakReference<Rift>(rift);
            this.entityId = rift.f_19820_;
            this.dimension = rift.m_9236_().m_46472_();
        }

        @Nullable
        public Rift compute() {
            Entity entity;
            ServerLevel level;
            Rift cached = this.get();
            MinecraftServer server = Midnight.getMinecraftServer();
            if (server != null && (level = server.m_129880_(this.dimension)) != null && cached == null && (entity = (Entity)level.m_142646_().m_142694_(this.entityId)) != null) {
                Rift rift = (Rift)entity;
                this.rift = new WeakReference<Rift>(rift);
                return rift;
            }
            return cached;
        }

        @Nullable
        public Rift get() {
            Rift rift;
            Rift rift2 = rift = this.rift != null ? (Rift)this.rift.get() : null;
            if (rift != null && this.isInvalid(rift)) {
                this.rift = null;
                return null;
            }
            return rift;
        }

        private boolean isInvalid(Rift rift) {
            return !rift.m_9236_().f_46443_ && ((ServerLevel)rift.m_9236_()).m_7654_().m_129880_(this.dimension) == null;
        }

        public boolean hasReference() {
            return this.entityId != null;
        }

        public CompoundTag save(CompoundTag compound) {
            if (this.entityId != null) {
                compound.m_128362_("id", this.entityId);
                compound.m_128359_("dimension", this.dimension.m_135782_().toString());
            }
            return compound;
        }

        public void load(CompoundTag compound) {
            if (compound.m_128403_("id")) {
                this.entityId = compound.m_128342_("id");
                this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
            }
        }
    }
}

