/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.projectile;

import com.crypticmushroom.minecraft.midnight.common.entity.projectile.FlyingItemEntity;
import com.crypticmushroom.minecraft.midnight.common.item.SporeBombItem;
import com.crypticmushroom.minecraft.midnight.common.particle.SimpleParticleWithOneInt;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThrownSporeBomb
extends FlyingItemEntity {
    private static final Supplier<? extends SporeBombItem> DEFAULT_ITEM = MnItems.NIGHTSHROOM_SPORE_BOMB;

    public ThrownSporeBomb(EntityType<? extends FlyingItemEntity> type, Level level) {
        super(type, level);
    }

    public ThrownSporeBomb(double x, double y, double z, Level level) {
        super((EntityType<? extends FlyingItemEntity>)((EntityType)MnEntityTypes.SPORE_BOMB.get()), x, y, z, level);
    }

    public ThrownSporeBomb(LivingEntity thrower, Level level) {
        super((EntityType<? extends FlyingItemEntity>)((EntityType)MnEntityTypes.SPORE_BOMB.get()), thrower, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_20069_()) {
            this.m_5552_(((Item)MnItems.DARK_PEARL.get()).m_7968_(), 0.1f);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(this.m_9236_().m_269111_().m_269390_((Entity)this, this.m_19749_()), 1.0f);
        this.explode();
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.explode();
    }

    private void explode() {
        Level level;
        if (this.m_9236_().f_46443_ || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SporeBombItem item = (SporeBombItem)this.m_7846_().m_41720_();
        SoundSource soundSource = this.m_19749_() != null ? this.m_19749_().m_5720_() : SoundSource.HOSTILE;
        serverLevel.m_8767_((ParticleOptions)new SimpleParticleWithOneInt((ParticleType<SimpleParticleWithOneInt>)((ParticleType)MnParticleTypes.BOMB_EXPLOSION.get()), item.getColor()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, soundSource, 1.0f, 1.0f);
        serverLevel.m_7967_((Entity)item.createLingeringCloud((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_()));
        this.m_146870_();
    }

    public void m_37446_(ItemStack stack) {
        if (!(stack.m_41720_() instanceof SporeBombItem)) {
            throw new IllegalStateException("Cannot set the itemstack of a Spore Bomb entity to a type other than SporeBombItem");
        }
        super.m_37446_(stack);
    }

    protected Item m_7881_() {
        return DEFAULT_ITEM.get();
    }
}

