/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.projectile;

import com.crypticmushroom.minecraft.midnight.common.entity.projectile.SpinningAbstractArrow;
import com.crypticmushroom.minecraft.midnight.common.item.BladeloopItem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEnchantments;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownBladeloop
extends SpinningAbstractArrow {
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(ThrownBladeloop.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Byte> RECALL_LEVEL = SynchedEntityData.m_135353_(ThrownBladeloop.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> IS_HORIZONTAL = SynchedEntityData.m_135353_(ThrownBladeloop.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean hasHit;
    public int clientSideReturnTickCount;
    public float baseDamage;
    private boolean thrownFromOffhand;

    public ThrownBladeloop(Level level, BladeloopItem item) {
        super((EntityType<? extends SpinningAbstractArrow>)((EntityType)MnEntityTypes.NAGRILITE_BLADELOOP.get()), level);
        ItemStack stack = item.m_7968_();
        this.f_19804_.m_135381_(RECALL_LEVEL, (Object)((byte)MnEnchantments.Util.getRecallLevel(stack)));
        this.baseDamage = item.getAttackDamage() + 1.0f;
        this.thrownFromOffhand = false;
        this.setItem(stack);
    }

    public ThrownBladeloop(Level level, LivingEntity shooter, ItemStack stack, boolean thrownFromOffhand) {
        super((EntityType<? extends SpinningAbstractArrow>)((EntityType)MnEntityTypes.NAGRILITE_BLADELOOP.get()), shooter, level);
        float f;
        this.f_19804_.m_135381_(RECALL_LEVEL, (Object)((byte)MnEnchantments.Util.getRecallLevel(stack)));
        Item item = stack.m_41720_();
        if (item instanceof BladeloopItem) {
            BladeloopItem bladeloop = (BladeloopItem)item;
            f = bladeloop.getAttackDamage() + 2.0f;
        } else {
            f = 1.0f;
        }
        this.baseDamage = f;
        this.thrownFromOffhand = thrownFromOffhand;
        this.setItem(stack);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RECALL_LEVEL, (Object)0);
        this.f_19804_.m_135372_(IS_HORIZONTAL, (Object)true);
        this.f_19804_.m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void setItem(ItemStack stack) {
        this.m_20088_().m_135381_(ITEM_STACK, (Object)stack);
    }

    public ItemStack m_7846_() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM_STACK);
    }

    @Override
    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.hasHit = true;
        }
        Entity owner = this.m_19749_();
        byte returningLevel = (Byte)this.f_19804_.m_135370_(RECALL_LEVEL);
        if (returningLevel > 0 && (this.hasHit || this.m_36797_()) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                Player player;
                if (!this.m_9236_().f_46443_ && owner instanceof Player && !(player = (Player)owner).m_7500_()) {
                    this.canPickup(player);
                }
                this.m_146870_();
                if (this.clientSideReturnTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    public void setVertical() {
        this.f_19804_.m_135381_(IS_HORIZONTAL, (Object)false);
    }

    public boolean isHorizontal() {
        return (Boolean)this.f_19804_.m_135370_(IS_HORIZONTAL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.hasHit ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        Entity owner = this.m_19749_();
        DamageSource source = this.m_269291_().m_269390_((Entity)this, (Entity)(owner == null ? this : owner));
        float damage = (Boolean)this.f_19804_.m_135370_(IS_HORIZONTAL) != false ? this.baseDamage : this.baseDamage + 2.0f;
        this.hasHit = true;
        if (target.m_6469_(source, damage) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if ((target.m_6095_() == EntityType.f_20566_ || target.m_6095_() == MnEntityTypes.NIGHTSHADE.get()) && owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)owner);
                EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)target);
            }
            this.m_7761_(livingTarget);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(SoundEvents.f_12201_, 1.0f, 1.0f);
    }

    @Override
    protected double getWeight() {
        return 0.05;
    }

    @Override
    protected double getSpinDelta() {
        return 25.0;
    }

    protected ItemStack m_7941_() {
        return this.m_7846_();
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12201_;
    }

    protected boolean m_142470_(Player player) {
        return switch (this.f_36705_) {
            case AbstractArrow.Pickup.ALLOWED -> {
                if (this.m_150171_((Entity)player) && this.canPickup(player)) {
                    yield true;
                }
                yield false;
            }
            case AbstractArrow.Pickup.CREATIVE_ONLY -> player.m_150110_().f_35937_;
            default -> false;
        };
    }

    protected boolean canPickup(Player player) {
        if (this.thrownFromOffhand && player.m_21206_().m_41619_()) {
            player.m_8061_(EquipmentSlot.OFFHAND, this.m_7941_());
            return true;
        }
        return player.m_150109_().m_36054_(this.m_7941_());
    }

    public void m_6123_(Player entity) {
        if (this.m_150171_((Entity)entity) || this.m_19749_() == null) {
            super.m_6123_(entity);
        }
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(RECALL_LEVEL);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Bladeloop"));
        this.setItem(stack);
        this.hasHit = compound.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(RECALL_LEVEL, (Object)((byte)MnEnchantments.Util.getRecallLevel(stack)));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        ItemStack stack = this.m_7846_();
        compound.m_128365_("Bladeloop", (Tag)stack.m_41739_(new CompoundTag()));
        compound.m_128379_("HasHit", this.hasHit);
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

