/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.projectile;

import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NovaSpikeEntity
extends ThrowableProjectile {
    private float damage = 4.0f;
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    private int ticksInGround;
    private int ticksInAir;

    public NovaSpikeEntity(double x, double y, double z, Level level) {
        super((EntityType)MnEntityTypes.NOVA_SPIKE.get(), x, y, z, level);
    }

    public NovaSpikeEntity(LivingEntity shooter, Level level) {
        super((EntityType)MnEntityTypes.NOVA_SPIKE.get(), shooter, level);
    }

    public NovaSpikeEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Entity thrower = this.m_19749_();
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            LivingEntity livingThrower;
            DamageSource damageSource;
            Entity entity = ((EntityHitResult)result).m_82443_();
            if (entity.m_6469_(damageSource = thrower.m_9236_().m_269111_().m_269299_((Entity)this, thrower instanceof LivingEntity ? (livingThrower = (LivingEntity)thrower) : null), this.damage)) {
                this.m_146870_();
            } else {
                this.m_20256_(this.m_20184_().m_82490_(-0.1));
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_19859_ += 180.0f;
                this.ticksInAir = 0;
                if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                    this.m_146870_();
                }
            }
        } else if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockState blockState = this.m_9236_().m_8055_(blockResult.m_82425_());
            BlockPos pos = this.m_20183_();
            if (!blockState.m_60812_((BlockGetter)this.m_9236_(), pos).m_83281_()) {
                this.inBlockState = blockState;
                Vec3 vec3d = blockResult.m_82450_().m_82546_(this.m_20182_());
                this.m_20256_(vec3d);
                Vec3 vec3d1 = vec3d.m_82541_().m_82490_(0.05);
                this.m_6034_((double)this.m_20183_().m_123341_() - vec3d1.f_82479_, (double)this.m_20183_().m_123342_() - vec3d1.f_82480_, (double)this.m_20183_().m_123343_() - vec3d1.f_82481_);
                this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                this.inGround = true;
                blockState.m_60669_(this.m_9236_(), blockState, blockResult, (Projectile)this);
            }
        }
    }

    public void m_8119_() {
        Vec3 motion = this.m_20184_();
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        if (this.inGround) {
            if (this.inBlockState != state && this.m_9236_().m_45772_(this.m_20191_().m_82400_(0.06))) {
                this.inGround = false;
                this.m_20256_(motion.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else if (!this.m_9236_().f_46443_) {
                this.m_6043_();
            }
            ++this.timeInGround;
        } else {
            super.m_8119_();
            this.m_20101_();
            this.m_9236_().m_7106_((ParticleOptions)MnParticleTypes.SPORE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.05, 0.0);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Life", this.ticksInGround);
        if (this.inBlockState != null) {
            compound.m_128365_("InBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.inBlockState));
        }
        compound.m_128379_("InGround", this.inGround);
        compound.m_128350_("Damage", this.damage);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInGround = compound.m_128451_("Life");
        if (compound.m_128425_("InBlockState", 10)) {
            this.inBlockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("InBlockState"));
        }
        this.inGround = compound.m_128471_("InGround");
        if (compound.m_128425_("Damage", 5)) {
            this.damage = compound.m_128457_("Damage");
        }
    }

    public void m_6043_() {
        if (++this.ticksInGround >= 300) {
            this.m_146870_();
        }
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void m_8097_() {
    }
}

