/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.misc;

import com.crypticmushroom.minecraft.midnight.common.block.UmbraflameBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;

public class UmbraLightningBolt
extends LightningBolt {
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    private int life;
    public long seed;
    private int flashes;
    protected boolean visualOnly;
    @Nullable
    private ServerPlayer cause;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    protected int blocksSetOnFire;
    private float damage = 5.0f;

    public UmbraLightningBolt(EntityType<? extends UmbraLightningBolt> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.life = 2;
        this.seed = this.f_19796_.m_188505_();
        this.flashes = this.f_19796_.m_188503_(3) + 1;
    }

    public boolean m_6783_(double distance) {
        return super.m_6783_(distance);
    }

    private void m_147161_() {
        BlockPos blockpos = this.m_147162_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            ((LightningRodBlock)blockstate.m_60734_()).m_153760_(blockstate, this.m_9236_(), blockpos);
        }
    }

    public void m_8119_() {
        super.m_6075_();
        if (this.life == 2) {
            if (this.m_9236_().m_5776_()) {
                float pitch = 0.8f + this.f_19796_.m_188501_() * 0.2f;
                int thunderSoundNum = this.m_9236_().m_213780_().m_188503_(3);
                RegistryObject<SoundEvent>[] thunderSound = thunderSoundNum == 0 ? MnSoundEvents.ENTITY_UMBRA_LIGHTNING_THUNDER1 : (thunderSoundNum == 1 ? MnSoundEvents.ENTITY_UMBRA_LIGHTNING_THUNDER2 : MnSoundEvents.ENTITY_UMBRA_LIGHTNING_THUNDER3);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)thunderSound[0].get(), SoundSource.WEATHER, 200.0f, pitch, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)thunderSound[1].get(), SoundSource.WEATHER, 7.5f, pitch, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)thunderSound[2].get(), SoundSource.WEATHER, 4.0f, pitch, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 3.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
            } else {
                Difficulty difficulty = this.m_9236_().m_46791_();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.m_20870_(4);
                }
                this.m_147161_();
                UmbraLightningBolt.m_147150_(this.m_9236_(), this.m_147162_());
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.m_9236_() instanceof ServerLevel) {
                    List list = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 15.0, this.m_20186_() - 15.0, this.m_20189_() - 15.0, this.m_20185_() + 15.0, this.m_20186_() + 6.0 + 15.0, this.m_20189_() + 15.0), p_147140_ -> p_147140_.m_6084_() && !this.hitEntities.contains(p_147140_));
                    for (ServerPlayer serverplayer : ((ServerLevel)this.m_9236_()).m_8795_(player -> player.m_20270_((Entity)this) < 256.0f)) {
                        CriteriaTriggers.f_145089_.m_153391_(serverplayer, (LightningBolt)this, list);
                    }
                }
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.f_19796_.m_188505_();
                this.m_20870_(0);
            }
        }
        if (this.life >= 0) {
            if (!(this.m_9236_() instanceof ServerLevel)) {
                this.m_9236_().m_6580_(2);
            } else if (!this.visualOnly) {
                List list1 = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                for (Entity entity : list1) {
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)this)) continue;
                    entity.m_8038_((ServerLevel)this.m_9236_(), (LightningBolt)this);
                }
                this.hitEntities.addAll(list1);
                if (this.cause != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.cause, (Collection)list1);
                }
            }
        }
    }

    private BlockPos m_147162_() {
        Vec3 vec3 = this.m_20182_();
        return BlockPos.m_274561_((double)vec3.f_82479_, (double)(vec3.f_82480_ - 1.0E-6), (double)vec3.f_82481_);
    }

    protected final void m_20870_(int extraIgnitions) {
        if (this.visualOnly || this.m_9236_().f_46443_ || !this.m_9236_().m_46469_().m_46207_(GameRules.f_46131_)) {
            return;
        }
        BlockPos placeFireOn = this.m_20183_();
        this.spawnFire(placeFireOn);
        for (int i = 0; i < extraIgnitions; ++i) {
            placeFireOn = placeFireOn.m_7918_(this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1, this.f_19796_.m_188503_(3) - 1);
            this.spawnFire(placeFireOn);
        }
    }

    @Deprecated
    protected void spawnFire(BlockPos blockPos) {
        BlockState blockState = ((UmbraflameBlock)((Object)MnBlocks.UMBRAFLAME.get())).m_49966_();
        if (this.m_9236_().m_8055_(blockPos).m_60795_() && blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) {
            this.m_9236_().m_46597_(blockPos, blockState);
            ++this.blocksSetOnFire;
        }
    }

    private static void m_147150_(Level level, BlockPos pos) {
        BlockState blockstate1;
        BlockPos blockpos;
        BlockState blockstate = level.m_8055_(pos);
        if (blockstate.m_60713_(Blocks.f_152587_)) {
            blockpos = pos.m_121945_(((Direction)blockstate.m_61143_((Property)LightningRodBlock.f_52588_)).m_122424_());
            blockstate1 = level.m_8055_(blockpos);
        } else {
            blockpos = pos;
            blockstate1 = blockstate;
        }
        if (blockstate1.m_60734_() instanceof WeatheringCopper) {
            level.m_46597_(blockpos, WeatheringCopper.m_154906_((BlockState)level.m_8055_(blockpos)));
            BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
            int i = level.f_46441_.m_188503_(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = level.f_46441_.m_188503_(8) + 1;
                UmbraLightningBolt.m_147145_(level, blockpos, blockpos$mutableblockpos, k);
            }
        }
    }

    private static void m_147145_(Level level, BlockPos pos, BlockPos.MutableBlockPos mutable, int steps) {
        Optional<BlockPos> optional;
        mutable.m_122190_((Vec3i)pos);
        for (int i = 0; i < steps && (optional = UmbraLightningBolt.m_147153_(level, (BlockPos)mutable)).isPresent(); ++i) {
            mutable.m_122190_((Vec3i)optional.get());
        }
    }

    private static Optional<BlockPos> m_147153_(Level level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_235650_((RandomSource)level.f_46441_, (int)10, (BlockPos)pos, (int)1)) {
            BlockState blockstate = level.m_8055_(blockpos);
            if (!(blockstate.m_60734_() instanceof WeatheringCopper)) continue;
            WeatheringCopper.m_154899_((BlockState)blockstate).ifPresent(p_147144_ -> level.m_46597_(blockpos, p_147144_));
            level.m_46796_(3002, blockpos, -1);
            return Optional.of(blockpos);
        }
        return Optional.empty();
    }
}

