/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.client.util.MnAnims;
import com.crypticmushroom.minecraft.midnight.common.entity.IMnPreventsSleep;
import com.crypticmushroom.minecraft.midnight.common.entity.living.TraditionalAgeableMob;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StingerEntity
extends TraditionalAgeableMob
implements Enemy,
IMnPreventsSleep,
GeoEntity,
SmartBrainOwner<StingerEntity> {
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StingerEntity(EntityType<? extends StingerEntity> entityType, Level level) {
        super(entityType, level, 5, 1200);
        this.f_21364_ = 5 + this.getTraditionalAge() * 2;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)MnAnims.ATTACK_STRIKE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    public List<ExtendedSensor<StingerEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new HurtBySensor()});
    }

    public BrainActivityGroup<StingerEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<StingerEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget(), new Idle().runFor(e -> e.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<StingerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(0)});
    }

    public double m_142593_(LivingEntity entity) {
        return 2.0;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public int m_21304_() {
        return 13;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    @Override
    protected void onTraditionalAgeChange(byte traditionalAge) {
        float maxHealth = 2.0f + (float)traditionalAge * 4.0f;
        this.m_21051_(Attributes.f_22276_).m_22100_((double)maxHealth);
        this.m_21153_(maxHealth);
        this.m_21051_(Attributes.f_22281_).m_22100_(1.0 + (double)traditionalAge);
        if (traditionalAge == this.maxTraditionalAge) {
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        }
        this.f_21364_ = 5 + traditionalAge * 2;
    }

    public float m_6134_() {
        return 0.5f + (float)this.getTraditionalAge() * 0.1f;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return this.m_146904_() <= 50 && super.m_5545_(level, spawnReason);
    }

    public void m_6043_() {
        if (!this.m_6162_()) {
            super.m_6043_();
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_STINGER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_STINGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_STINGER_DEATH.get();
    }

    public int m_8100_() {
        return 100;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 20 + this.getTraditionalAge() * 20, 0));
            }
            return true;
        }
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }
}

