/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.monster;

import com.crypticmushroom.minecraft.midnight.common.entity.base.MnFlyingMonster;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomFlyingTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hunter
extends MnFlyingMonster<Hunter> {
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Hunter(EntityType<? extends Hunter> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericFlyController((GeoAnimatable)this).setAnimationSpeed(0.6).setSoundKeyframeHandler(event -> {})});
        controllers.add(new AnimationController[]{DefaultAnimations.genericAttackAnimation((LivingEntity)this, (RawAnimation)DefaultAnimations.ATTACK_STRIKE).setAnimationSpeed((double)1.3f)});
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.m_26440_(false);
        navigation.m_26443_(false);
        return navigation;
    }

    public List<ExtendedSensor<Hunter>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor()});
    }

    public BrainActivityGroup<Hunter> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<Hunter> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new SetPlayerLookTarget(), new SetRandomLookTarget()}), new SetRandomFlyingTarget().verticalWeight(e -> -1).speedModifier(0.9f)});
    }

    public BrainActivityGroup<Hunter> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget<Mob>(){

            protected void start(Mob entity) {
                Brain brain = entity.m_6274_();
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                if (entity.m_21574_().m_148306_((Entity)target) && BehaviorUtils.m_22632_((Mob)entity, (LivingEntity)target, (int)1)) {
                    BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26370_);
                } else {
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
                    BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, true), ((Float)this.speedMod.apply(entity, target)).floatValue(), ((Integer)this.closeEnoughWhen.apply(entity, target)).intValue()));
                }
            }
        }, new AnimatableMeleeAttack(6)});
    }

    @Override
    public int getAttackSwingDuration() {
        return 13;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)MnSoundEvents.ENTITY_HUNTER_FLYING.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_HUNTER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_HUNTER_DEATH.get();
    }
}

