/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.creature.ambient;

import com.crypticmushroom.minecraft.midnight.common.entity.network.MnEntityDataAccessor;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.NearbyBlocksSensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrystalBugEntity
extends PathfinderMob
implements SmartBrainOwner<CrystalBugEntity>,
GeoEntity,
FlyingAnimal {
    private final AnimatableInstanceCache animationFactory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final MnEntityDataAccessor<Boolean> IS_RESTING = new MnEntityDataAccessor("isResting", SynchedEntityData.m_135353_(CrystalBugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_));

    public CrystalBugEntity(EntityType<? extends CrystalBugEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 4;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, false);
    }

    public boolean m_21255_() {
        return super.m_21255_();
    }

    public static AttributeSupplier.Builder attributes() {
        return CrystalBugEntity.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, 0.7).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, level);
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_RESTING, (Object)false);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animate)});
    }

    private PlayState animate(AnimationState<CrystalBugEntity> event) {
        String animation = this.isResting() ? "crystalBug.sleep" : "crystalBug.walk";
        return event.setAndContinue(RawAnimation.begin().thenLoop(animation));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationFactory;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType reason) {
        return this.m_20097_().m_123342_() > level.m_5736_() && super.m_5545_(level, reason);
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(IS_RESTING);
    }

    public void setResting(boolean resting) {
        this.f_19804_.m_135381_(IS_RESTING, (Object)resting);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IS_RESTING, (Object)compound.m_128471_(IS_RESTING.getKey()));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(IS_RESTING.getKey(), ((Boolean)this.f_19804_.m_135370_(IS_RESTING)).booleanValue());
    }

    @Deprecated
    protected boolean canStayOnBlock(BlockState state) {
        return state.m_204336_(MnBlockTags.CRYSTAL_BUG_CAN_REST_ON);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_6090_() {
        return true;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ / 3.0f;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)MnSoundEvents.ENTITY_CRYSTAL_BUG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)MnSoundEvents.ENTITY_CRYSTAL_BUG_DEATH.get();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.setResting(false);
            return true;
        }
        return false;
    }

    protected void m_7324_(Entity entity) {
        this.setResting(false);
        super.m_7324_(entity);
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    protected Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<CrystalBugEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyBlocksSensor().setRadius(3.0).setPredicate((state, entity) -> state.m_204336_(MnBlockTags.CRYSTAL_BUG_CAN_REST_ON))});
    }

    public BrainActivityGroup<CrystalBugEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new TryHeal().cooldownFor(e -> 30), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new MoveToWalkTarget(), new Idle().runFor(e -> e.m_217043_().m_216339_(160, 240)).startCondition(e -> BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.IN_RESTING_SEQUENCE.get()))).stopIf(e -> !e.isResting()).whenStarting(e -> e.setResting(true)).whenStopping(e -> e.setResting(false))})});
    }

    public BrainActivityGroup<CrystalBugEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetRandomHoverTarget().setRadius(6.0, 4.0).startCondition(e -> BrainUtils.hasMemory((LivingEntity)e, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.IN_RESTING_SEQUENCE.get())) || e.m_217043_().m_188501_() < 0.5f).whenStopping(e -> BrainUtils.clearMemories((LivingEntity)e, (MemoryModuleType[])new MemoryModuleType[]{(MemoryModuleType)MnMemoryTypes.IN_RESTING_SEQUENCE.get()})), new TrySetWalkTargetFromRememberedBlocks()})});
    }

    public boolean m_29443_() {
        return !this.isResting();
    }

    protected static class TryHeal<E extends CrystalBugEntity>
    extends ExtendedBehaviour<E> {
        protected TryHeal() {
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return Collections.emptyList();
        }

        protected void start(E entity) {
            entity.m_5634_(1.0f);
        }

        protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
            return entity.m_21223_() < entity.m_21233_() && ((CrystalBugEntity)((Object)entity)).isResting();
        }
    }

    protected static class TrySetWalkTargetFromRememberedBlocks<E extends CrystalBugEntity>
    extends ExtendedBehaviour<E> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()), (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)MnMemoryTypes.IN_RESTING_SEQUENCE.get()), (Object)MemoryStatus.VALUE_ABSENT)});

        protected TrySetWalkTargetFromRememberedBlocks() {
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void start(E entity) {
            BlockPos targetPos = this.getTargetPos(entity);
            if (targetPos != null) {
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(targetPos, 1.0f, 0));
                BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.IN_RESTING_SEQUENCE.get()), (Object)Unit.INSTANCE);
            } else {
                BrainUtils.clearMemories(entity, (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.f_26370_});
            }
        }

        @Nullable
        protected BlockPos getTargetPos(E entity) {
            List rememberedBlocks = (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_BLOCKS.get()));
            BlockPos abovePos = ((BlockPos)((Pair)rememberedBlocks.get(((CrystalBugEntity)entity).f_19796_.m_188503_(rememberedBlocks.size()))).getFirst()).m_7494_();
            BlockState aboveState = entity.m_9236_().m_8055_(abovePos);
            return aboveState.m_60795_() || aboveState.m_60713_((Block)MnBlocks.BLOOMCRYSTAL.get()) ? abovePos : null;
        }
    }
}

