/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class FishJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final AbstractFish fish;
    private final int interval;
    private boolean breached;

    public FishJumpGoal(AbstractFish fish, int interval) {
        this.fish = fish;
        this.interval = FishJumpGoal.m_186073_((int)interval);
    }

    public boolean m_8036_() {
        if (this.fish.m_217043_().m_188503_(this.interval) != 0) {
            return false;
        }
        Direction direction = this.fish.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.fish.m_20183_();
        for (int k : STEPS_TO_CHECK) {
            if (this.waterIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos pos, int dx, int dz, int scale) {
        BlockPos blockpos = pos.m_7918_(dx * scale, 0, dz * scale);
        return this.fish.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13131_) && !this.fish.m_9236_().m_8055_(blockpos).m_280555_();
    }

    private boolean surfaceIsClear(BlockPos pos, int dx, int dz, int scale) {
        return this.fish.m_9236_().m_8055_(pos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && this.fish.m_9236_().m_8055_(pos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.fish.m_20184_().f_82480_;
        return !(d0 * d0 < (double)0.03f && this.fish.m_146909_() != 0.0f && Math.abs(this.fish.m_146909_()) < 10.0f && this.fish.m_20069_() || this.fish.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.fish.m_6374_();
        this.fish.m_20256_(this.fish.m_20184_().m_82520_((double)direction.m_122429_() * 0.6, 0.7, (double)direction.m_122431_() * 0.6));
        this.fish.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.fish.m_146926_(0.0f);
    }

    public void m_8037_() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.fish.m_9236_().m_6425_(this.fish.m_20183_());
            this.breached = fluidstate.m_205070_(FluidTags.f_13131_);
        }
        if (this.breached && !flag) {
            this.fish.m_5496_(SoundEvents.f_11917_, 1.0f, 1.0f);
        }
        Vec3 vec3 = this.fish.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.fish.m_146909_() != 0.0f) {
            this.fish.m_146926_(Mth.m_14189_((float)this.fish.m_146909_(), (float)0.0f, (float)0.2f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d0 = vec3.m_165924_();
            double d1 = Math.atan2(-vec3.f_82480_, d0) * 57.2957763671875;
            this.fish.m_146926_((float)d1);
        }
    }
}

