/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.living.ai.goal;

import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;

public class EatFoodGoal
extends Goal {
    private static final byte ITEM_EATEN_ENTITY_EVENT = 45;
    private static final int DEFAULT_EATING_INTERVAL = MathUtil.secondsToTicks(10);
    private final Mob mob;
    private final Ingredient ingredient;
    private final int eatingInterval;
    private int eatTicks;

    public EatFoodGoal(Mob mob, Ingredient ingredient) {
        this(mob, ingredient, DEFAULT_EATING_INTERVAL);
    }

    public EatFoodGoal(Mob mob, Ingredient ingredient, int eatingIntervalInTicks) {
        this.mob = mob;
        this.ingredient = ingredient;
        this.eatingInterval = eatingIntervalInTicks;
    }

    public boolean m_8036_() {
        return this.mob.m_6084_() && this.canEatItem();
    }

    private ItemStack getItemInHand() {
        return this.mob.m_21120_(InteractionHand.MAIN_HAND);
    }

    private void setItemInHand(ItemStack itemStack) {
        this.mob.m_21008_(InteractionHand.MAIN_HAND, itemStack);
    }

    private boolean canEatItem() {
        return this.ingredient.test(this.getItemInHand());
    }

    public void m_8037_() {
        --this.eatTicks;
        ItemStack item = this.getItemInHand();
        if (this.eatTicks < 0) {
            ItemStack used = item.m_41671_(this.mob.m_9236_(), (LivingEntity)this.mob);
            if (!used.m_41619_()) {
                this.setItemInHand(used);
            }
            this.mob.m_5634_(2.0f);
            this.eatTicks = this.eatingInterval;
            this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)45);
        }
    }

    public void m_8041_() {
        this.eatTicks = this.eatingInterval;
    }

    public static interface Handler {
        default public void handleEatFoodEvent(Mob mob, byte id) {
            if (id != 45) {
                return;
            }
            ItemStack item = mob.m_21120_(InteractionHand.MAIN_HAND);
            mob.m_216990_(mob.m_7866_(item));
            this.spawnFoodParticles(mob, item);
        }

        default public void spawnFoodParticles(Mob mob, ItemStack item) {
            if (item.m_41619_()) {
                return;
            }
            for (int i = 0; i < 8; ++i) {
                Vec3 vec3d = MathUtil.rotatePitchAndYaw(new Vec3(((double)mob.m_217043_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0), -mob.f_20885_ * ((float)Math.PI / 180), -mob.f_20886_ * ((float)Math.PI / 180));
                mob.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), mob.m_20185_() + mob.m_20154_().f_82479_ / 2.0, mob.m_20186_(), mob.m_20189_() + mob.m_20154_().f_82481_ / 2.0, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
            }
        }
    }
}

