/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToNearbyRift<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()), (Object)MemoryStatus.VALUE_PRESENT)});
    protected BiPredicate<E, Rift> predicate = (entity, rift) -> true;
    protected BiFunction<E, Rift, Float> speedMod = (entity, rift) -> Float.valueOf(1.0f);
    protected Rift target = null;

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public SetWalkTargetToNearbyRift<E> predicate(BiPredicate<E, Rift> predicate) {
        this.predicate = predicate;
        return this;
    }

    public SetWalkTargetToNearbyRift<E> speedMod(BiFunction<E, Rift, Float> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        for (Rift rift : (List)BrainUtils.getMemory(entity, (MemoryModuleType)((MemoryModuleType)MnMemoryTypes.NEARBY_RIFTS.get()))) {
            if (!this.predicate.test(entity, rift)) continue;
            this.target = rift;
            break;
        }
        return this.target != null;
    }

    protected void start(E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)this.target, false), this.speedMod.apply(entity, this.target).floatValue(), 0));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.target.m_20183_().m_6630_(2)));
    }

    protected void stop(E entity) {
        this.target = null;
    }
}

