/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.entity.behaviour;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class ApplyAttributeModifierBehaviour<E extends LivingEntity>
extends ExtendedBehaviour<E> {
    protected final Multimap<Attribute, Tuple<AttributeModifier, Predicate<E>>> attributeModifiers;

    private ApplyAttributeModifierBehaviour(Multimap<Attribute, Tuple<AttributeModifier, Predicate<E>>> attributeModifiers) {
        this.attributeModifiers = attributeModifiers;
    }

    public static <E extends LivingEntity> Builder<E> builder() {
        return new Builder();
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    protected void start(E entity) {
        this.attributeModifiers.forEach((attribute, tuple) -> this.tryApplyModifier(entity, (Attribute)attribute, (Tuple<AttributeModifier, Predicate<E>>)tuple));
    }

    private void tryApplyModifier(E entity, Attribute attribute, Tuple<AttributeModifier, Predicate<E>> tuple) {
        AttributeInstance instance = entity.m_21051_(attribute);
        AttributeModifier mod = (AttributeModifier)tuple.m_14418_();
        Predicate predicate = (Predicate)tuple.m_14419_();
        boolean shouldApply = predicate.test(entity);
        if (shouldApply != instance.m_22109_(mod)) {
            if (shouldApply) {
                instance.m_22125_(mod);
            } else {
                instance.m_22130_(mod);
            }
        }
    }

    public static class Builder<E extends LivingEntity> {
        private final ImmutableMultimap.Builder<Attribute, Tuple<AttributeModifier, Predicate<E>>> multimapBuilder = ImmutableMultimap.builder();

        public Builder<E> addModifier(Attribute attribute, AttributeModifier modifier) {
            this.multimapBuilder.put((Object)attribute, (Object)new Tuple((Object)modifier, e -> true));
            return this;
        }

        public Builder<E> addModifier(Attribute attribute, AttributeModifier modifier, Predicate<E> predicate) {
            this.multimapBuilder.put((Object)attribute, (Object)new Tuple((Object)modifier, predicate));
            return this;
        }

        public ApplyAttributeModifierBehaviour<E> build() {
            return new ApplyAttributeModifierBehaviour(this.multimapBuilder.build());
        }
    }
}

