/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.enchantment;

import com.crypticmushroom.minecraft.midnight.common.enchantment.MidnightEnchantment;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEnchantments;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;

public class BogStriderEnchantment
extends MidnightEnchantment {
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("be645cee-b99a-4fec-ae9c-b49872ebb036");

    public BogStriderEnchantment() {
        super(Enchantment.Rarity.UNCOMMON, EnchantmentCategory.ARMOR_FEET, EquipmentSlot.FEET);
    }

    public int m_6586_() {
        return 3;
    }

    protected boolean m_5975_(Enchantment other) {
        return super.m_5975_(other) && other != Enchantments.f_44976_;
    }

    public static void onChangedBlock(LivingEntity entity) {
        if (BogStriderEnchantment.shouldRemoveModifier(entity, entity.m_20075_())) {
            BogStriderEnchantment.removeModifier(entity);
        }
        BogStriderEnchantment.tryAddModifier(entity);
    }

    public static void onFall(LivingEntity entity) {
        BogStriderEnchantment.removeModifier(entity);
        BogStriderEnchantment.tryAddModifier(entity);
    }

    private static void tryAddModifier(LivingEntity livingEntity) {
        int level;
        if (!livingEntity.m_20075_().m_60795_() && (level = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)MnEnchantments.BOG_STRIDER.get()), (LivingEntity)livingEntity)) > 0 && BogStriderEnchantment.onBogBlock(livingEntity)) {
            AttributeInstance attributeinstance = livingEntity.m_21051_(Attributes.f_22279_);
            if (attributeinstance == null) {
                return;
            }
            attributeinstance.m_22118_(new AttributeModifier(SPEED_MODIFIER_UUID, "Soul speed boost", (double)(0.03f * (1.0f + (float)level * 0.35f)), AttributeModifier.Operation.ADDITION));
            if (livingEntity.m_217043_().m_188501_() < 0.04f) {
                ItemStack stack = livingEntity.m_6844_(EquipmentSlot.FEET);
                stack.m_41622_(1, livingEntity, living -> living.m_21166_(EquipmentSlot.FEET));
            }
        }
    }

    private static boolean shouldRemoveModifier(LivingEntity livingEntity, BlockState state) {
        return !state.m_60795_() || livingEntity.m_21255_();
    }

    private static void removeModifier(LivingEntity livingEntity) {
        AttributeInstance attributeinstance = livingEntity.m_21051_(Attributes.f_22279_);
        if (attributeinstance != null && attributeinstance.m_22111_(SPEED_MODIFIER_UUID) != null) {
            attributeinstance.m_22120_(SPEED_MODIFIER_UUID);
        }
    }

    public static boolean onBogBlock(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150110_().f_35935_) {
                return false;
            }
        }
        return livingEntity.m_9236_().m_8055_(BlockPos.m_274561_((double)livingEntity.m_20182_().f_82479_, (double)(livingEntity.m_20191_().f_82289_ - 0.5000001), (double)livingEntity.m_20182_().f_82481_)).m_204336_(MnBlockTags.WET_SOILS);
    }
}

