/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.compatibility.jade;

import com.crypticmushroom.minecraft.midnight.common.compatibility.jade.MnWailaPlugin;
import com.crypticmushroom.minecraft.midnight.common.entity.living.TraditionalAgeableMob;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.addon.vanilla.MobGrowthProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum TraditionalAgeJadeProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation ID;
    private static final String TRADITIONAL_AGE_KEY;
    private static final String TRADITIONAL_AGE_NBT = "TraditionalAge";
    private static final String TIME_UNTIL_NEXT_AGE_NBT = "TimeUntilNextTraditionalAge";

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().m_128441_(TRADITIONAL_AGE_NBT)) {
            tooltip.remove(MobGrowthProvider.INSTANCE.getUid());
            TraditionalAgeableMob mob = (TraditionalAgeableMob)accessor.getEntity();
            CompoundTag data = accessor.getServerData();
            byte age = data.m_128445_(TRADITIONAL_AGE_NBT);
            int time = data.m_128451_(TIME_UNTIL_NEXT_AGE_NBT);
            tooltip.add((Component)Component.m_237110_((String)TRADITIONAL_AGE_KEY, (Object[])new Object[]{age, mob.getMaxTraditionalAge()}));
            tooltip.add((Component)Component.m_237110_((String)"jade.mobgrowth.time", (Object[])new Object[]{time / 20}));
        }
    }

    public void appendServerData(CompoundTag data, EntityAccessor entity) {
        Entity entity2 = entity.getEntity();
        if (entity2 instanceof TraditionalAgeableMob) {
            TraditionalAgeableMob mob = (TraditionalAgeableMob)entity2;
            data.m_128344_(TRADITIONAL_AGE_NBT, mob.getTraditionalAge());
            data.m_128405_(TIME_UNTIL_NEXT_AGE_NBT, mob.ticksUntilNextTraditionalAge());
        }
    }

    public ResourceLocation getUid() {
        return ID;
    }

    static {
        ID = MnWailaPlugin.createId("traditional_age", "Age");
        TRADITIONAL_AGE_KEY = MnWailaPlugin.text("traditional_age", "Age: %d/%d");
    }
}

