/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.capability.entity;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.capability.CapabilityProvider;
import com.crypticmushroom.minecraft.midnight.common.capability.IPersistentCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.ISyncedCapability;
import com.crypticmushroom.minecraft.midnight.common.capability.entity.BaseMnEntity;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.capability.MnLivingEntityPacket;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class MnLivingEntity
implements BaseMnEntity<LivingEntity>,
IPersistentCapability<MnLivingEntity>,
ISyncedCapability {
    public static final Capability<MnLivingEntity> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<MnLivingEntity>(){});
    private final LivingEntity entity;
    private static final int RIFT_TRAVELER_COOLDOWN = 40;
    @Nullable
    private Rift enteredRift;
    private int riftEntryCooldown;

    public static void attach(AttachCapabilitiesEvent<? extends Entity> event) {
        Object object = event.getObject();
        if (!(object instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)object;
        event.addCapability(Midnight.id("living_entity"), new CapabilityProvider<MnLivingEntity>(new MnLivingEntity(entity)));
    }

    private MnLivingEntity(LivingEntity entity) {
        this.entity = entity;
    }

    @Override
    public LivingEntity getEntity() {
        return this.entity;
    }

    private void commonTick(LivingEvent.LivingTickEvent event) {
        if (this.riftEntryCooldown > 0) {
            AABB hitbox = this.entity.m_20191_();
            if (this.entity.m_9236_().m_45976_(Rift.class, hitbox).isEmpty()) {
                --this.riftEntryCooldown;
            }
        }
    }

    public void clientTick(LivingEvent.LivingTickEvent event) {
        this.commonTick(event);
    }

    public void serverTick(LivingEvent.LivingTickEvent event) {
        this.commonTick(event);
        this.riftTravelerServerTick(event);
    }

    private void riftTravelerServerTick(LivingEvent.LivingTickEvent event) {
        if (this.enteredRift == null || !this.canEnterRift()) {
            return;
        }
        if (!this.enteredRift.isEndpointLoaded()) {
            this.enteredRift.getBridge().computeEndpoint(this.enteredRift.getEndpointDimension());
            if (!this.enteredRift.isEndpointLoaded()) {
                return;
            }
        }
        ServerLevel destination = Midnight.getMinecraftServer().m_129880_(this.enteredRift.getEndpointDimension());
        Entity teleportedEntity = this.getEntity().changeDimension(destination, (ITeleporter)this.enteredRift);
        if (teleportedEntity != null && teleportedEntity != this.getEntity()) {
            teleportedEntity.f_19789_ = 0.0f;
            MnLivingEntity.ifPresent((LivingEntity)teleportedEntity, e -> e.setRiftEntryCooldown(40));
        } else if (teleportedEntity == this.getEntity()) {
            this.setRiftEntryCooldown(40);
        }
        this.enteredRift = null;
    }

    public void enterRift(Rift rift) {
        if (!this.canEnterRift()) {
            return;
        }
        this.enteredRift = rift;
    }

    public int getRiftEntryCooldown() {
        return this.riftEntryCooldown;
    }

    public void setRiftEntryCooldown(int cooldown) {
        this.riftEntryCooldown = cooldown;
    }

    public boolean canEnterRift() {
        return this.getRiftEntryCooldown() <= 0;
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return tag;
    }

    @Override
    public void load(CompoundTag tag) {
    }

    @Override
    public void syncDataToClient() {
        if (this.getEntity().m_9236_().f_46443_) {
            return;
        }
        MnLivingEntityPacket packet = new MnLivingEntityPacket(this);
        MnNetwork.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getEntity), (Object)packet);
    }

    @Override
    public Capability<MnLivingEntity> getDefaultInstance() {
        return INSTANCE;
    }

    public static <E extends LivingEntity> boolean isPresent(E entity) {
        if (entity == null) {
            return false;
        }
        return entity.getCapability(INSTANCE).resolve().isPresent();
    }

    public static <E extends LivingEntity> void ifPresent(E entity, Consumer<MnLivingEntity> action) {
        if (entity == null) {
            return;
        }
        entity.getCapability(INSTANCE).resolve().ifPresent(action);
    }

    public static <E extends LivingEntity, R> R getIfPresent(E entity, Function<MnLivingEntity, R> action, Supplier<R> orElse) {
        Optional capability;
        if (entity != null && (capability = entity.getCapability(INSTANCE).resolve()).isPresent()) {
            return action.apply((MnLivingEntity)capability.get());
        }
        return orElse.get();
    }
}

