/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.capability;

import com.crypticmushroom.minecraft.midnight.common.capability.IPersistentCapability;
import com.crypticmushroom.minecraft.registry.util.Lazy;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;

public class CapabilityProvider<C extends IPersistentCapability<C>>
implements ICapabilitySerializable<CompoundTag> {
    private static final NonNullSupplier<IllegalStateException> EXCEPTION = () -> new IllegalStateException("Capability handler was holding a null or empty capability!");
    private final LazyOptional<C> capabilityHandler = LazyOptional.of(() -> capability);
    private final Lazy<Capability<C>> instance = Lazy.of(() -> capability.getDefaultInstance());

    public CapabilityProvider(C capability) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == this.instance.get() ? this.capabilityHandler.cast() : LazyOptional.empty();
    }

    public void deserializeNBT(CompoundTag compound) {
        this.get().load(compound);
    }

    public CompoundTag serializeNBT() {
        return this.get().save(new CompoundTag());
    }

    private C get() {
        return (C)((IPersistentCapability)this.capabilityHandler.orElseThrow(EXCEPTION));
    }
}

