/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.util;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MnVoxelShapes {
    public static final VoxelShape BOX_12_13 = MnVoxelShapes.box(12.0, 13.0);
    public static final VoxelShape BOX_7_10 = MnVoxelShapes.box(7.0, 10.0);
    public static final VoxelShape BOX_15_2 = MnVoxelShapes.box(15.0, 2.0);
    public static final VoxelShape HANGING_BOX_12_13 = MnVoxelShapes.hangingBox(12.0, 13.0);
    public static final VoxelShape BOX_13_16 = MnVoxelShapes.box(13.0, 16.0);
    public static final VoxelShape BOX_13_11 = MnVoxelShapes.box(13.0, 11.0);
    public static final VoxelShape[] SHROOM_SHELF_BOXES = new VoxelShape[]{null, MnVoxelShapes.directionalBox(12.0, 4.0, Direction.UP), MnVoxelShapes.directionalBox(10.0, 4.0, 12.0, Direction.NORTH), MnVoxelShapes.directionalBox(10.0, 4.0, 12.0, Direction.SOUTH), MnVoxelShapes.directionalBox(10.0, 4.0, 12.0, Direction.WEST), MnVoxelShapes.directionalBox(10.0, 4.0, 12.0, Direction.EAST)};
    public static final VoxelShape[] BLADESHROOM_BOXES = MnVoxelShapes.createBoxArray(14.0, 9.0);
    public static final VoxelShape[] CRYSTALOTUS_BOXES = MnVoxelShapes.createBoxArray(14.0, 3.0);

    public static VoxelShape box(double width, double height) {
        return MnVoxelShapes.directionalBox(width, height, Direction.UP);
    }

    public static VoxelShape hangingBox(double width, double height) {
        return MnVoxelShapes.directionalBox(width, height, Direction.DOWN);
    }

    public static VoxelShape directionalBox(double width, double height, Direction dir) {
        return MnVoxelShapes.directionalBox(width, width, height, dir);
    }

    public static VoxelShape directionalBox(double width, double length, double height, Direction dir) {
        double widthRadius = width / 2.0;
        double lengthRadius = length / 2.0;
        switch (dir) {
            case DOWN: {
                return Block.m_49796_((double)(8.0 - lengthRadius), (double)(16.0 - height), (double)(8.0 - widthRadius), (double)(8.0 + lengthRadius), (double)16.0, (double)(8.0 + widthRadius));
            }
            default: {
                return Block.m_49796_((double)(8.0 - lengthRadius), (double)0.0, (double)(8.0 - widthRadius), (double)(8.0 + lengthRadius), (double)height, (double)(8.0 + widthRadius));
            }
            case NORTH: {
                return Block.m_49796_((double)(8.0 - widthRadius), (double)(8.0 - lengthRadius), (double)(16.0 - height), (double)(8.0 + widthRadius), (double)(8.0 + lengthRadius), (double)16.0);
            }
            case SOUTH: {
                return Block.m_49796_((double)(8.0 - widthRadius), (double)(8.0 - lengthRadius), (double)0.0, (double)(8.0 + widthRadius), (double)(8.0 + lengthRadius), (double)height);
            }
            case WEST: {
                return Block.m_49796_((double)(16.0 - height), (double)(8.0 - lengthRadius), (double)(8.0 - widthRadius), (double)16.0, (double)(8.0 + lengthRadius), (double)(8.0 + widthRadius));
            }
            case EAST: 
        }
        return Block.m_49796_((double)0.0, (double)(8.0 - lengthRadius), (double)(8.0 - widthRadius), (double)height, (double)(8.0 + lengthRadius), (double)(8.0 + widthRadius));
    }

    public static VoxelShape fullVerticalBox(double width) {
        double radius = width / 2.0;
        return Block.m_49796_((double)(8.0 - radius), (double)0.0, (double)(8.0 - radius), (double)(8.0 + radius), (double)16.0, (double)(8.0 + radius));
    }

    public static VoxelShape[] createBoxArray(double size, double height) {
        double r = size / 2.0;
        VoxelShape[] shapes = new VoxelShape[6];
        for (Direction dir : Direction.values()) {
            double e1;
            Direction.Axis axis = dir.m_122434_();
            Direction.AxisDirection axdir = dir.m_122421_();
            boolean neg = axdir == Direction.AxisDirection.NEGATIVE;
            double c0 = 8.0 - r;
            double c1 = 8.0 + r;
            double e0 = neg ? 16.0 - height : 0.0;
            double d = e1 = neg ? 16.0 : height;
            VoxelShape shape = axis == Direction.Axis.X ? Block.m_49796_((double)e0, (double)c0, (double)c0, (double)e1, (double)c1, (double)c1) : (axis == Direction.Axis.Y ? Block.m_49796_((double)c0, (double)e0, (double)c0, (double)c1, (double)e1, (double)c1) : Block.m_49796_((double)c0, (double)c0, (double)e0, (double)c1, (double)c1, (double)e1));
            shapes[dir.ordinal()] = shape;
        }
        return shapes;
    }
}

