/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.type;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.block.type.MnBlockSetTypes;
import com.crypticmushroom.minecraft.registry.util.Lazy;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.util.ForgeSoundType;
import org.jetbrains.annotations.ApiStatus;

public class MnWoodTypes {
    private static final Set<Lazy<WoodType>> ALL = new HashSet<Lazy<WoodType>>();
    static boolean forceInitialized = false;
    public static final Lazy<WoodType> SHADOWROOT = MnWoodTypes.register(MnBlockSetTypes.SHADOWROOT);
    public static final Lazy<WoodType> DARK_WILLOW = MnWoodTypes.register(MnBlockSetTypes.DARK_WILLOW);
    public static final Lazy<WoodType> DECAYED_WOOD = MnWoodTypes.register(MnBlockSetTypes.DECAYED_WOOD);
    public static final Lazy<WoodType> MANGLEWOOD = MnWoodTypes.register(MnBlockSetTypes.MANGLEWOOD);
    public static final Lazy<WoodType> NIGHTSHROOM = MnWoodTypes.register(MnBlockSetTypes.NIGHTSHROOM);
    public static final Lazy<WoodType> DEWSHROOM = MnWoodTypes.register(MnBlockSetTypes.DEWSHROOM);
    public static final Lazy<WoodType> VIRIDSHROOM = MnWoodTypes.register(MnBlockSetTypes.VIRIDSHROOM);
    public static final Lazy<WoodType> MOONSHROOM = MnWoodTypes.register(MnBlockSetTypes.MOONSHROOM);
    public static final Lazy<WoodType> BOGSHROOM = MnWoodTypes.register(MnBlockSetTypes.BOGSHROOM);

    private static Lazy<WoodType> register(MnBlockSetTypes.LazyBlockSetType setType) {
        Lazy type = Lazy.of(() -> WoodType.m_61844_((WoodType)new WoodType(Midnight.idStr(setType.name), (BlockSetType)setType.get())));
        ALL.add((Lazy<WoodType>)type);
        return type;
    }

    private static Lazy<WoodType> register(MnBlockSetTypes.LazyBlockSetType setType, ForgeSoundType soundType, ForgeSoundType hangingSignSoundType, Supplier<? extends SoundEvent> fenceGateClose, Supplier<? extends SoundEvent> fenceGateOpen) {
        Lazy type = Lazy.of(() -> WoodType.m_61844_((WoodType)new WoodType(Midnight.idStr(setType.name), (BlockSetType)setType.get(), (SoundType)soundType, (SoundType)hangingSignSoundType, (SoundEvent)fenceGateClose.get(), (SoundEvent)fenceGateOpen.get())));
        ALL.add((Lazy<WoodType>)type);
        return type;
    }

    @ApiStatus.Internal
    public static void forceInit() {
        if (!forceInitialized) {
            MnBlockSetTypes.forceInit();
            ALL.forEach(Supplier::get);
            forceInitialized = true;
        }
    }
}

