/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.block.plant.BoxConfigurableBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnVoxelShapes;
import com.crypticmushroom.minecraft.midnight.common.network.MnNetwork;
import com.crypticmushroom.minecraft.midnight.common.network.level.VioleafHealPacket;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class VioleafPlantBlock
extends BoxConfigurableBushBlock
implements BonemealableBlock {
    public static final BooleanProperty GROWN = MnBlockStateProperties.GROWN;
    private static final int PARTICLE_COUNT = 32;

    public VioleafPlantBlock(BlockBehaviour.Properties properties) {
        super(properties, MnBlockTags.SOILS, false, MnVoxelShapes.BOX_7_10, true);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GROWN});
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)GROWN) == false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(true)), 3);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.m_7370_((LevelReader)level, pos, state, level.f_46443_) && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            this.m_214148_(level, random, pos, state);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.f_46443_ && ((Boolean)state.m_61143_((Property)GROWN)).booleanValue() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.f_19797_ % 20 == 0 && livingEntity.m_21023_(MobEffects.f_19604_)) {
                livingEntity.m_21195_(MobEffects.f_19604_);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)GROWN, (Comparable)Boolean.valueOf(false)), 2);
                world.m_5594_(null, pos, SoundEvents.f_11755_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
                Vec3 offset = state.m_60824_((BlockGetter)world, pos);
                double posX = (double)pos.m_123341_() + 0.5 + offset.f_82479_;
                double posY = (double)pos.m_123342_() + 0.3;
                double posZ = (double)pos.m_123343_() + 0.5 + offset.f_82481_;
                VioleafHealPacket packet = new VioleafHealPacket(new Vec3(posX, posY, posZ));
                MnNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.m_46745_(pos)), (Object)packet);
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    MnCriteriaTriggers.VIOLEAF_CURE_NAUSEA.m_222618_(serverPlayer);
                }
            }
        }
    }

    public static void spawnParticles(LevelAccessor level, Vec3 pos) {
        if (level == null) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            Vec3 vel = new Vec3(level.m_213780_().m_188500_() * 2.0 - 1.0, level.m_213780_().m_188500_() * 2.0 - 1.0, level.m_213780_().m_188500_() * 2.0 - 1.0).m_82541_().m_82490_(level.m_213780_().m_188500_() * 0.02 + 0.02);
            Vec3 loc = new Vec3(level.m_213780_().m_188500_() * 2.0 - 1.0, level.m_213780_().m_188500_() * 2.0 - 1.0, level.m_213780_().m_188500_() * 2.0 - 1.0).m_82490_(0.2).m_82549_(pos);
            double extraYV = level.m_213780_().m_188500_() * 0.1;
            vel = vel.m_82520_(0.0, extraYV, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, loc.f_82479_, loc.f_82480_, loc.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }
}

