/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.BoxConfigurableBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnVoxelShapes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TendrilweedPlantBlock
extends BoxConfigurableBushBlock {
    public TendrilweedPlantBlock(BlockBehaviour.Properties props) {
        super(props, MnBlockTags.SOILS, true, MnVoxelShapes.BOX_12_13, true);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level.f_46443_) {
            Vec3 velo = entity.m_20184_();
            double speed = velo.m_82553_();
            if (speed < 0.01) {
                return;
            }
            double particleChance = Mth.m_14008_((double)speed, (double)0.0, (double)0.2);
            if (level.f_46441_.m_188500_() < particleChance) {
                Vec3 motion = speed > 0.2 ? velo.m_82541_().m_82490_(0.2) : velo;
                TendrilweedPlantBlock.spawnPollen(level, pos, state, level.f_46441_, motion.m_82490_(0.4));
            }
        }
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rng) {
        if (rng.m_188503_(26) == 0) {
            TendrilweedPlantBlock.spawnPollen(world, pos, state, rng, Vec3.f_82478_);
        }
    }

    private static void spawnPollen(Level level, BlockPos pos, BlockState state, RandomSource rng, Vec3 motion) {
        Vec3 offset = state.m_60824_((BlockGetter)level, pos);
        double x = (double)pos.m_123341_() + offset.f_82479_ + (rng.m_188500_() * 2.0 - 1.0) / 4.0 + 0.5;
        double y = (double)pos.m_123342_() + offset.f_82480_ + rng.m_188500_() * 0.92;
        double z = (double)pos.m_123343_() + offset.f_82481_ + (rng.m_188500_() * 2.0 - 1.0) / 4.0 + 0.5;
        level.m_7106_((ParticleOptions)MnParticleTypes.TENDRIL_POLLEN.get(), x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
    }

    public static void spawnPollenCloud(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        for (int i = 0; i < 10; ++i) {
            TendrilweedPlantBlock.spawnPollen(level, pos, state, level.f_46441_, new Vec3(level.f_46441_.m_188500_() * 2.0 - 1.0, level.f_46441_.m_188500_() * 2.0 - 1.0, level.f_46441_.m_188500_() * 2.0 - 1.0).m_82490_(0.004));
        }
    }
}

