/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.CustomPlaceableBush;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DirectionalBushBlock
extends BushBlock
implements CustomPlaceableBush {
    private final VoxelShape[] shapes;
    private final TagKey<Block> plantableBlocks;

    public DirectionalBushBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, Direction defaultDirection, VoxelShape ... shapes) {
        super(properties);
        this.shapes = shapes;
        this.plantableBlocks = plantableBlocks;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getFacingProperty(), (Comparable)defaultDirection));
    }

    public DirectionalBushBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, VoxelShape ... shapes) {
        this(properties, plantableBlocks, Direction.UP, shapes);
    }

    public DirectionProperty getFacingProperty() {
        return BlockStateProperties.f_61372_;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getFacingProperty()});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction[] nearestDirs = ctx.m_6232_();
        BlockState state = this.m_49966_();
        for (Direction dir : nearestDirs) {
            Direction facing = dir.m_122424_();
            if (!this.getFacingProperty().m_6908_().contains(facing) || !this.m_7898_(state = (BlockState)state.m_61124_((Property)this.getFacingProperty(), (Comparable)facing), (LevelReader)level, pos)) continue;
            return state;
        }
        return null;
    }

    @Override
    public TagKey<Block> getPlantableBlocks() {
        return this.plantableBlocks;
    }

    @Override
    public Direction getFaceDirectionAttachedTo(BlockState state) {
        return (Direction)state.m_61143_((Property)this.getFacingProperty());
    }

    public BlockState m_7417_(BlockState state, Direction facingDir, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facingDir.m_122424_() == state.m_61143_((Property)this.getFacingProperty()) && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes[((Direction)state.m_61143_((Property)this.getFacingProperty())).ordinal()];
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        DirectionProperty dir = this.getFacingProperty();
        return (BlockState)state.m_61124_((Property)dir, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)dir)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        DirectionProperty dir = this.getFacingProperty();
        return (BlockState)state.m_61124_((Property)dir, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)dir)));
    }
}

