/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.DirectionalBushBlock;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnVoxelShapes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDamageTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.crypticmushroom.minecraft.midnight.data.tag.MnBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BladeshroomBushBlock
extends DirectionalBushBlock
implements BonemealableBlock {
    private static final int REGROW_CHANCE = 10;
    public static final IntegerProperty STAGE = MnBlockStateProperties.STAGE_0_2;

    public BladeshroomBushBlock(BlockBehaviour.Properties properties) {
        super(properties, MnBlockTags.SHROOM_GROWABLE, MnVoxelShapes.BLADESHROOM_BOXES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)this.getFacingProperty(), (Comparable)Direction.DOWN));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE});
        builder.m_61104_(new Property[]{this.getFacingProperty()});
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return (Integer)state.m_61143_((Property)STAGE) == 2 ? BlockPathTypes.DAMAGE_OTHER : super.getBlockPathType(state, level, pos, mob);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)STAGE) == 2) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)MnItems.BLADESHROOM_CAP.get()));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1)), 1);
            player.m_6469_(level.m_269111_().m_269079_(MnDamageTypes.BLADESHROOM), 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if ((Integer)state.m_61143_((Property)STAGE) == 2) {
            entity.m_6469_(level.m_269111_().m_269079_(MnDamageTypes.BLADESHROOM), 1.0f);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            this.incrementStage((Level)level, pos, state);
        }
    }

    private void incrementStage(Level level, BlockPos pos, BlockState state) {
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (stage == 2) {
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 1);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)((BladeshroomBushBlock)MnBlocks.BLADESHROOM.get()).m_5456_());
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)STAGE) < 2;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.incrementStage((Level)level, pos, state);
    }
}

