/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.block.util.MnBlockStateProperties;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class SuavisBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty STAGE = MnBlockStateProperties.STAGE_0_3;
    private static final VoxelShape[] BOUNDS = new VoxelShape[]{SuavisBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), SuavisBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), SuavisBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), SuavisBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final double[] HEIGHTS = new double[]{4.0, 7.0, 13.0, 16.0};

    public SuavisBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE});
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance);
        if (!level.f_46443_ && (double)fallDistance > 0.5 && entity.canTrample(level.m_8055_(pos), pos, fallDistance)) {
            boolean isFirstStage;
            boolean bl = isFirstStage = (Integer)state.m_61143_((Property)STAGE) == 0;
            if (!isFirstStage && level.f_46441_.m_188503_(100) == 0) {
                level.m_46961_(pos, true);
            } else {
                SoundType type = this.getSoundType(state, (LevelReader)level, pos, entity);
                level.m_5594_(null, pos, type.m_56775_(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                level.m_46796_(2001, pos, SuavisBlock.m_49956_((BlockState)state));
                SuavisBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MnItems.RAW_SUAVIS.get()));
                level.m_7731_(pos, isFirstStage ? Blocks.f_50016_.m_49966_() : (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STAGE) - 1)), 3);
                if (!(entity instanceof Player) || !((Player)entity).m_7500_()) {
                    SuavisBlock.createNauseaCloud(level, pos, 0, isFirstStage ? 0.0 : SuavisBlock.heightOf((Integer)state.m_61143_((Property)STAGE) - 1));
                }
            }
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        if (!level.m_5776_()) {
            if (!player.m_7500_() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) == 0) {
                SuavisBlock.createNauseaCloud(level, pos, (Integer)state.m_61143_((Property)STAGE), 0.0);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                MnCriteriaTriggers.DESTROY_SUAVIS.m_222618_(serverPlayer);
            }
        }
    }

    private static void createNauseaCloud(Level level, BlockPos pos, int intensity, double height) {
        AreaEffectCloud nausea = new AreaEffectCloud(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3 + height, (double)pos.m_123343_() + 0.5);
        nausea.m_19716_(new MobEffectInstance(MobEffects.f_19604_, 20 * (intensity + 1) * 6, 0, false, true));
        nausea.m_19712_(1.5f + 0.5f * (float)intensity);
        nausea.m_19732_(-0.3f);
        nausea.m_19740_(10);
        nausea.m_19738_(-nausea.m_19743_() / (float)nausea.m_19748_());
        nausea.m_19714_(3495830);
        level.m_7967_((Entity)nausea);
    }

    private static double heightOf(int stage) {
        return HEIGHTS[stage];
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)STAGE) < 3;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)STAGE) < 3;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState newState = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STAGE) + 1));
        level.m_7731_(pos, newState, 2);
        SuavisBlock.m_49897_((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)STAGE) < 3 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            this.m_214148_(level, random, pos, state);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == Direction.DOWN && !this.canRemain((LevelReader)level, currentPos)) {
            level.m_46961_(currentPos, false);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.canRemain(world, pos);
    }

    private boolean canRemain(LevelReader level, BlockPos pos) {
        BlockState down = level.m_8055_(pos.m_7495_());
        return down.m_60734_() != this && down.m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP) || down.m_60734_() == MnBlocks.DECEITFUL_MUD.get();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)STAGE) < 3;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return (Integer)state.m_61143_((Property)STAGE) == 3 ? new ItemStack((ItemLike)this) : new ItemStack((ItemLike)MnItems.RAW_SUAVIS.get());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(3));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BOUNDS[(Integer)state.m_61143_((Property)STAGE)];
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return (Integer)state.m_61143_((Property)STAGE) < 2;
    }
}

