/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.block.ShroomAirBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ShroomCapBlock
extends Block {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private final int sporeColor;

    public ShroomCapBlock(BlockBehaviour.Properties properties, int sporeColor) {
        super(properties);
        this.sporeColor = sporeColor;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        state = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (neighborState.m_60713_((Block)this) || neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_())) {
            state = (BlockState)state.m_61124_((Property)ShroomCapBlock.getProperty(direction), (Comparable)Boolean.valueOf(false));
        }
        if (neighborState.m_60795_() && !(neighborState.m_60734_() instanceof ShroomAirBlock) && !((Boolean)state.m_61143_((Property)ShroomCapBlock.getProperty(direction))).booleanValue()) {
            ShroomCapBlock.placeShroomAir(level, neighborPos);
        }
        return state;
    }

    private static void placeShroomAir(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60795_() && !(state.m_60734_() instanceof ShroomAirBlock)) {
            level.m_7731_(pos, ((ShroomAirBlock)((Object)MnBlocks.SHROOM_AIR.get())).m_49966_(), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack usedItem = player.m_21120_(hand);
        Direction direction = hit.m_82434_();
        BooleanProperty faceProp = ShroomCapBlock.getProperty(direction);
        if (usedItem.m_41720_() != Items.f_42574_ || !((Boolean)state.m_61143_((Property)faceProp)).booleanValue()) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)faceProp, (Comparable)Boolean.valueOf(false)));
        ShroomCapBlock.placeShroomAir((LevelAccessor)level, pos.m_121945_(direction));
        usedItem.m_41622_(1, (LivingEntity)player, p -> {});
        level.m_5594_(null, pos, SoundEvents.f_12196_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        for (Direction dir : Direction.values()) {
            BlockPos adjPos = pos.m_121945_(dir);
            BlockState adjState = world.m_8055_(adjPos);
            if (!adjState.m_60713_((Block)this) && !adjState.m_60783_((BlockGetter)world, adjPos, dir.m_122424_())) continue;
            state = (BlockState)state.m_61124_((Property)ShroomCapBlock.getProperty(dir), (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        boolean n = (Boolean)state.m_61143_((Property)NORTH);
        boolean e = (Boolean)state.m_61143_((Property)EAST);
        boolean s = (Boolean)state.m_61143_((Property)SOUTH);
        boolean w = (Boolean)state.m_61143_((Property)WEST);
        return switch (rot) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> state;
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(n))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(e))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(s))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(w));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(n))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(e))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(s));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(s))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(w))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(n))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(e));
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        boolean n = (Boolean)state.m_61143_((Property)NORTH);
        boolean e = (Boolean)state.m_61143_((Property)EAST);
        boolean s = (Boolean)state.m_61143_((Property)SOUTH);
        boolean w = (Boolean)state.m_61143_((Property)WEST);
        return switch (mirror) {
            default -> throw new IncompatibleClassChangeError();
            case Mirror.NONE -> state;
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(s))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(n));
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(w))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(e));
        };
    }

    public int getSporeColor() {
        return this.sporeColor;
    }

    public static BooleanProperty getProperty(Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
        };
    }
}

