/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.block.ShroomCapBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.common.util.ColorUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ShroomAirBlock
extends AirBlock {
    public ShroomAirBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState m_7417_(BlockState state, Direction defaultDir, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        for (Direction dir : Direction.values()) {
            boolean shouldBeShroomAir;
            BlockState side = level.m_8055_(currentPos.m_121945_(dir));
            boolean bl = shouldBeShroomAir = side.m_60734_() instanceof ShroomCapBlock && (Boolean)side.m_61143_((Property)ShroomCapBlock.getProperty(dir.m_122424_())) == false;
            if (!shouldBeShroomAir) continue;
            return state;
        }
        level.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 3);
        return Blocks.f_50016_.m_49966_();
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (Direction direction : Direction.values()) {
            BlockState adjState = level.m_8055_(pos.m_121945_(direction));
            Block adj = adjState.m_60734_();
            if (!(adj instanceof ShroomCapBlock) || ((Boolean)adjState.m_61143_((Property)ShroomCapBlock.getProperty(direction.m_122424_()))).booleanValue()) continue;
            colors.add(((ShroomCapBlock)adj).getSporeColor());
        }
        if (!colors.isEmpty() && random.m_188503_(39) < 4) {
            int count = random.m_188503_(2) + 1;
            for (int i = 0; i < count; ++i) {
                int col = (Integer)colors.get(random.m_188503_(colors.size()));
                double r = ColorUtil.redd(col);
                double g = ColorUtil.greend(col);
                double b = ColorUtil.blued(col);
                double x = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - random.m_188500_() + random.m_188500_() - random.m_188500_()) / 2.0;
                double y = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - random.m_188500_() + random.m_188500_() - random.m_188500_()) / 2.0;
                double z = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - random.m_188500_() + random.m_188500_() - random.m_188500_()) / 2.0;
                level.m_7106_((ParticleOptions)MnParticleTypes.SHROOM_SPORE.get(), x, y, z, r, g, b);
            }
        }
    }
}

