/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.block.MidnightDirtBlock;
import com.crypticmushroom.minecraft.midnight.common.block.plant.GrowablePlantBlock;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;

public class NightGrassBlock
extends MidnightDirtBlock
implements BonemealableBlock {
    public NightGrassBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int myStatus = NightGrassBlock.getGrowStatusAt(level, pos);
        if (myStatus == -1) {
            level.m_46597_(pos, ((MidnightDirtBlock)((Object)MnBlocks.NIGHT_DIRT.get())).m_49966_());
        } else {
            for (int i = 0; i < 4; ++i) {
                BlockPos randomNearby = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(5) - 3, random.m_188503_(3) - 1);
                BlockState nearState = level.m_8055_(randomNearby);
                if (nearState.m_60734_() != MnBlocks.NIGHT_DIRT.get() || NightGrassBlock.getGrowStatusAt(level, randomNearby) != 1) continue;
                level.m_46597_(randomNearby, this.m_49966_());
            }
        }
    }

    private static int getGrowStatusAt(ServerLevel level, BlockPos pos) {
        BlockPos up = pos.m_7494_();
        BlockState upstate = level.m_8055_(up);
        if (!NightGrassBlock.doesLightGoThroughBlockAbove(level.m_8055_(pos), (LevelReader)level, pos, upstate, up)) {
            return -1;
        }
        if (upstate.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return 0;
        }
        return 1;
    }

    private static boolean doesLightGoThroughBlockAbove(BlockState state, LevelReader level, BlockPos pos, BlockState upState, BlockPos upPos) {
        if (upState.m_60734_() == Blocks.f_50125_ && (Integer)upState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1) {
            return true;
        }
        int opac = LightEngine.m_284282_((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)upState, (BlockPos)upPos, (Direction)Direction.UP, (int)upState.m_60739_((BlockGetter)level, upPos));
        return opac < level.m_7469_();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        BlockPos up = pos.m_7494_();
        BlockState upState = level.m_8055_(up);
        return upState.m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos up = pos.m_7494_();
        BlockState plant = ((GrowablePlantBlock)MnBlocks.NIGHT_GRASS.get()).m_49966_();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos placePos = up;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    BlockState currState = level.m_8055_(placePos);
                    if (currState.m_60734_() == plant.m_60734_() && random.m_188503_(10) == 0) {
                        ((BonemealableBlock)plant.m_60734_()).m_214148_(level, random, placePos, currState);
                    }
                    if (!currState.m_60795_() || !plant.m_60710_((LevelReader)level, placePos)) continue block0;
                    level.m_7731_(placePos, plant, 3);
                    continue block0;
                }
                if (level.m_8055_((placePos = placePos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_7495_()).m_60734_() != this || level.m_8055_(placePos).m_60804_((BlockGetter)level, placePos)) continue block0;
                ++j;
            }
        }
    }
}

