/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConfigurableDirectionalBlock
extends DirectionalBlock {
    private final VoxelShape[] shapes = new VoxelShape[6];

    public ConfigurableDirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ConfigurableDirectionalBlock hitbox(double size, double height) {
        double r = size / 2.0;
        for (Direction dir : Direction.values()) {
            double e1;
            Direction.Axis axis = dir.m_122434_();
            Direction.AxisDirection axdir = dir.m_122421_();
            boolean neg = axdir == Direction.AxisDirection.NEGATIVE;
            double c0 = 8.0 - r;
            double c1 = 8.0 + r;
            double e0 = neg ? 16.0 - height : 0.0;
            double d = e1 = neg ? 16.0 : height;
            VoxelShape shape = axis == Direction.Axis.X ? ConfigurableDirectionalBlock.m_49796_((double)e0, (double)c0, (double)c0, (double)e1, (double)c1, (double)c1) : (axis == Direction.Axis.Y ? ConfigurableDirectionalBlock.m_49796_((double)c0, (double)e0, (double)c0, (double)c1, (double)e1, (double)c1) : ConfigurableDirectionalBlock.m_49796_((double)c0, (double)c0, (double)e0, (double)c1, (double)c1, (double)e1));
            this.shapes[dir.ordinal()] = shape;
        }
        return this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.shapes[((Direction)state.m_61143_((Property)f_52588_)).ordinal()];
    }

    public BlockState m_7417_(BlockState state, Direction facingDir, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canHang((BlockGetter)level, currentPos, facingDir)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    protected boolean canHang(BlockGetter level, BlockPos pos, Direction facing) {
        BlockPos supportPos = pos.m_121945_(facing.m_122424_());
        BlockState supportState = level.m_8055_(supportPos);
        return this.isValidSupportBlock(supportState, level, supportPos, facing);
    }

    protected boolean isValidSupportBlock(BlockState state, BlockGetter level, BlockPos pos, Direction facing) {
        return state.m_60783_(level, pos, facing) || state.m_60713_((Block)MnBlocks.DECEITFUL_MUD.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_});
    }
}

