/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.util;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.block.util.NightGrassColorModifying;
import com.crypticmushroom.minecraft.midnight.common.util.ColorUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;

public final class ClientColorUtil {
    public static int modifyGrassColor(int base, BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
        int minDistSq = 100;
        int nearestCol = base;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int dx = -2; dx < 2; ++dx) {
            for (int dy = -2; dy < 2; ++dy) {
                for (int dz = -2; dz < 2; ++dz) {
                    mpos.m_122190_((Vec3i)pos).m_122184_(dx, dy, dz);
                    if (mpos.equals((Object)pos)) continue;
                    try {
                        BlockState newState = level.m_8055_((BlockPos)mpos);
                        Block block = newState.m_60734_();
                        if (!(block instanceof NightGrassColorModifying)) continue;
                        NightGrassColorModifying colorModifier = (NightGrassColorModifying)block;
                        int distSq = dx * dx + dy * dy + dz * dz;
                        if (distSq >= minDistSq) continue;
                        minDistSq = distSq;
                        nearestCol = colorModifier.getNightGrassColorModifier(level, mpos.m_7949_(), state);
                        continue;
                    }
                    catch (NullPointerException | MissingPaletteEntryException e) {
                        Midnight.LOGGER.fatal("Failed to get a block state with the mutable position", e);
                        Midnight.LOGGER.fatal("Please report this to the Midnight issue tracker!");
                    }
                }
            }
        }
        if (nearestCol == base) {
            return base;
        }
        double minDist = Math.sqrt(minDistSq);
        return ColorUtil.interpolate(nearestCol, base, Mth.m_14008_((double)(minDist / 2.0), (double)0.0, (double)1.0));
    }
}

