/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer.shader;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.RiftRenderer;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.jetbrains.annotations.Nullable;

public final class MnShaders
extends RenderStateShard {
    public static final ShaderInstanceProvider RIFT = new ShaderInstanceProvider("rendertype_rift", state -> RenderType.m_173215_((String)"midnight_rift", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(state).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(RiftRenderer.RIFT_TEXTURE, false, false).m_173132_(RiftRenderer.RIFT_NOISE, false, false).m_173131_()).m_110685_(f_110139_).m_110671_(f_110153_).m_110677_(f_110155_).m_110661_(f_110110_).m_110691_(false)));

    public static void addEventListeners(IEventBus modBus) {
        modBus.addListener(MnShaders::registerShaders);
    }

    private static void registerShaders(RegisterShadersEvent event) {
        try {
            ShaderInstanceProvider.registerAll(event);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to register shaders", e);
        }
    }

    private MnShaders(String name, Runnable setupState, Runnable clearState) {
        super(name, setupState, clearState);
    }

    public static final class ShaderInstanceProvider
    implements Supplier<ShaderInstance> {
        private static final List<ShaderInstanceProvider> ALL = new ArrayList<ShaderInstanceProvider>();
        private final String name;
        private final RenderType renderType;
        @Nullable
        private ShaderInstance instance;

        public ShaderInstanceProvider(String name, Function<RenderStateShard.ShaderStateShard, RenderType> renderType) {
            this.name = name;
            this.renderType = renderType.apply(new RenderStateShard.ShaderStateShard(() -> this.instance));
            ALL.add(this);
        }

        private static void registerAll(RegisterShadersEvent event) throws IOException {
            for (ShaderInstanceProvider provider : ALL) {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), Midnight.id(provider.name), provider.renderType.m_110508_()), instance -> {
                    provider.instance = instance;
                });
            }
        }

        @Override
        public ShaderInstance get() {
            return this.instance;
        }

        public RenderType getRenderType() {
            return this.renderType;
        }
    }
}

