/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer;

import com.crypticmushroom.minecraft.midnight.client.compatibility.lucent.MnLucentPlugin;
import com.crypticmushroom.minecraft.midnight.client.model.entity.NovaSpikeModel;
import com.crypticmushroom.minecraft.midnight.client.renderer.blockentity.MnChestRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.BladeloopRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.EboniteArrowRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.HunterRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.NightshadeRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.NightstagRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.NovaRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.NovaSpikeRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.RiftRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.RifterRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.SlinkRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.SpinningItemProjectileRenderer;
import com.crypticmushroom.minecraft.midnight.client.renderer.entity.StingerRenderer;
import com.crypticmushroom.minecraft.midnight.client.util.RenderingUtil;
import com.crypticmushroom.minecraft.midnight.common.item.BlockEntityItem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlockEntities;
import com.crypticmushroom.minecraft.midnight.common.registry.MnBlocks;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnItems;
import com.legacy.lucent.api.data.objects.EntityLighting;
import com.legacy.lucent.api.data.objects.ItemLighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public final class MidnightRendering {

    public static final class BlockEntities {
        public static final IClientItemExtensions ITEM_RENDERER = new IClientItemExtensions(){
            private final Lazy<BlockEntityWithoutLevelRenderer> entityRenderer = Lazy.of(() -> new BlockEntityWithoutLevelRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()){

                public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                    BlockEntityItem blockItem;
                    Item item = stack.m_41720_();
                    if (item instanceof BlockEntityItem && (blockItem = (BlockEntityItem)item).getBlockEntity().isPresent()) {
                        BlockEntity blockEntity = (BlockEntity)blockItem.getBlockEntity().orElseThrow(() -> new UnsupportedOperationException("BlockEntity was expected, but not supplied."));
                        Minecraft.m_91087_().m_167982_().m_112272_(blockEntity, poseStack, buffer, packedLight, packedOverlay);
                    } else {
                        super.m_108829_(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
                    }
                }
            });

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.entityRenderer.get();
            }
        };

        public static void setupRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)MnBlockEntities.CHEST.get(), MnChestRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)MnBlockEntities.SIGN.get(), SignRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)MnBlockEntities.HANGING_SIGN.get(), HangingSignRenderer::new);
        }
    }

    public static final class Entities {
        public static void setupLightings(MnLucentPlugin.EntityLightings lightings) {
            lightings.register(EntityLighting.builder().entity((EntityType)MnEntityTypes.CRYSTAL_BUG.get()).light((Block)MnBlocks.BLOOMCRYSTAL_ROCK.get()).build());
            lightings.register(EntityLighting.builder().entity((EntityType)MnEntityTypes.RIFT.get()).light(15).build());
            lightings.register(EntityLighting.builder().entity((EntityType)MnEntityTypes.CORRUPTED_PEARL.get()).light(7).build());
        }

        public static void setupLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(NovaSpikeModel.LAYER_LOCATION, NovaSpikeModel::createBodyLayer);
        }

        public static void setupRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)MnEntityTypes.RIFT.get(), RiftRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.CORRUPTED_PEARL.get(), context -> new ThrownItemRenderer(context, 1.0f, true));
            event.registerEntityRenderer((EntityType)MnEntityTypes.EBONITE_ARROW.get(), EboniteArrowRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.GEODE.get(), context -> new ThrownItemRenderer(context));
            event.registerEntityRenderer((EntityType)MnEntityTypes.SPORE_BOMB.get(), context -> new ThrownItemRenderer(context));
            event.registerEntityRenderer((EntityType)MnEntityTypes.STINGER_EGG.get(), context -> new ThrownItemRenderer(context));
            event.registerEntityRenderer((EntityType)MnEntityTypes.AREA_EFFECT_CLOUD.get(), NoopRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.BLADESHROOM_CAP.get(), SpinningItemProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.NAGRILITE_BLADELOOP.get(), BladeloopRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.NOVA_SPIKE.get(), NovaSpikeRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.HUNTER.get(), HunterRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.STINGER.get(), StingerRenderer::new);
            Entities.registerRenderer(event, MnEntityTypes.TENEVIXEN);
            event.registerEntityRenderer((EntityType)MnEntityTypes.NIGHTSHADE.get(), NightshadeRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.SLINK.get(), SlinkRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.NIGHTSTAG.get(), NightstagRenderer::new);
            Entities.registerRenderer(event, MnEntityTypes.DECEITFUL_SNAPPER);
            event.registerEntityRenderer((EntityType)MnEntityTypes.NOVA.get(), NovaRenderer::new);
            Entities.registerRenderer(event, MnEntityTypes.CRYSTAL_BUG);
            event.registerEntityRenderer((EntityType)MnEntityTypes.UMBRA_LIGHTNING_BOLT.get(), LightningBoltRenderer::new);
            event.registerEntityRenderer((EntityType)MnEntityTypes.RIFTER.get(), RifterRenderer::new);
        }

        private static <E extends LivingEntity> void registerRenderer(EntityRenderersEvent.RegisterRenderers event, RegistryObject<EntityType<E>> entity) {
            event.registerEntityRenderer((EntityType)entity.get(), RenderingUtil.createEntityRenderer(entity));
        }
    }

    public static final class Items {
        public static void setupLightings(MnLucentPlugin.ItemLightings lightings) {
            lightings.register(ItemLighting.builder().item((Item)MnItems.CORRUPTED_PEARL.get()).light(7));
            lightings.register(ItemLighting.builder().item((Item)MnItems.RIFT_PLACER.get()).light(9));
        }
    }

    public static final class Blocks {
        public static void setupTextureLightings(MnLucentPlugin.BlockTextureLightings lightings) {
        }
    }
}

