/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.particle;

import com.crypticmushroom.minecraft.midnight.client.particle.RiftParticle;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.common.registry.MnParticleTypes;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import com.crypticmushroom.minecraft.midnight.coremod.mixin.accessor.ParticleEngineAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;

public class RiftParticleSystem {
    private static final int ORBITAL_RING_COUNT = 3;
    private static final int ORBITAL_PARTICLE_COUNT = 240;
    private final Rift rift;
    private RiftParticle.Ring[] particleRings;
    private int releasedParticleCount;

    public RiftParticleSystem(Rift rift) {
        this.rift = rift;
    }

    public void updateParticles() {
        if (this.rift.isBridgeInvalid()) {
            return;
        }
        if (!MnDimensions.THE_MIDNIGHT.is(this.rift.m_9236_()) && this.rift.m_9236_().f_46441_.m_188503_(10) == 0) {
            this.spawnSpore(3.0f);
        }
        if (this.rift.isOpen()) {
            this.updateRings();
            if (!this.rift.isUnstable()) {
                this.spawnOrbitalParticles();
            }
        } else if (this.rift.getBridge().open.getTimer() == 2) {
            int sporeCount = this.rift.m_9236_().f_46441_.m_188503_(3) + 8;
            for (int i = 0; i < sporeCount; ++i) {
                this.spawnSpore(1.0f);
            }
        }
    }

    public Rift getEntity() {
        return this.rift;
    }

    private void spawnSpore(float displacementScale) {
        double velocityX = this.rift.m_9236_().f_46441_.m_188583_() * (double)0.3f;
        double velocityY = this.rift.m_9236_().f_46441_.m_188583_() * (double)0.3f;
        double velocityZ = this.rift.m_9236_().f_46441_.m_188583_() * (double)0.3f;
        double particleX = this.rift.m_20185_() + velocityX * (double)displacementScale;
        double particleY = this.rift.m_20186_() + (double)(this.rift.m_20206_() / 2.0f) + velocityY * (double)displacementScale;
        double particleZ = this.rift.m_20189_() + velocityZ * (double)displacementScale;
        Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)MnParticleTypes.AMBIENT_SPORE.get(), particleX, particleY, particleZ, velocityX, velocityY, velocityZ);
    }

    private void updateRings() {
        if (this.particleRings == null) {
            this.particleRings = this.generateOrbitalRings();
        }
        for (RiftParticle.Ring ring : this.particleRings) {
            ring.update();
        }
    }

    private RiftParticle.Ring[] generateOrbitalRings() {
        RiftParticle.Ring[] rings = new RiftParticle.Ring[3];
        for (int i = 0; i < rings.length; ++i) {
            float tiltX = this.rift.m_9236_().f_46441_.m_188501_() * 360.0f;
            float tiltZ = this.rift.m_9236_().f_46441_.m_188501_() * 360.0f;
            Vec2 tiltSpeed = new Vec2(this.rift.m_9236_().f_46441_.m_188501_(), this.rift.m_9236_().f_46441_.m_188501_()).m_165902_();
            rings[i] = new RiftParticle.Ring(tiltX, tiltZ, tiltSpeed.f_82470_ * 0.05f, tiltSpeed.f_82471_ * 0.05f);
        }
        return rings;
    }

    private void spawnOrbitalParticles() {
        ParticleEngine particles = Minecraft.m_91087_().f_91061_;
        int count = Math.min(this.rift.m_9236_().f_46441_.m_188503_(2) + 1, 240 - this.releasedParticleCount);
        for (int i = 0; i < count; ++i) {
            float offsetHorizontal = (this.rift.m_9236_().f_46441_.m_188501_() - 0.5f) * this.rift.m_20205_() * 0.8f;
            float offsetVertical = (this.rift.m_9236_().f_46441_.m_188501_() - 0.5f) * this.rift.m_20206_() * 0.8f;
            float theta = MathUtil.toRadiansStrict(this.rift.m_146908_());
            double x = this.rift.m_20185_() + (double)(Mth.m_14089_((float)theta) * offsetHorizontal);
            double y = this.rift.m_20186_() + (double)(this.rift.m_20206_() / 2.0f) + (double)offsetVertical;
            double z = this.rift.m_20189_() + (double)(Mth.m_14031_((float)theta) * offsetHorizontal);
            RiftParticle.Ring ring = this.particleRings[this.rift.m_9236_().f_46441_.m_188503_(this.particleRings.length)];
            float radius = this.rift.m_9236_().f_46441_.m_188501_() + 2.5f;
            float angleOffset = this.rift.m_9236_().f_46441_.m_188501_() * 360.0f;
            float verticalOffset = (this.rift.m_9236_().f_46441_.m_188501_() - 0.5f) * 0.25f;
            float rotateSpeed = this.rift.m_9236_().f_46441_.m_188501_() * 0.5f + 1.25f;
            RiftParticle particle = new RiftParticle(this, ring, (ClientLevel)this.rift.m_9236_(), x, y, z, radius, angleOffset, verticalOffset, rotateSpeed, ((ParticleEngineAccessor)particles).midnight$spriteSets().get(MnParticleTypes.SPORE.getId()));
            particles.m_107344_((Particle)particle);
            ++this.releasedParticleCount;
        }
    }

    public void returnParticle() {
        --this.releasedParticleCount;
    }
}

