/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.particle;

import com.crypticmushroom.minecraft.midnight.client.particle.MnTextureSheetParticle;
import com.crypticmushroom.minecraft.midnight.common.particle.SimpleParticleWithOneInt;
import com.crypticmushroom.minecraft.midnight.common.util.ColorUtil;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.util.TriConsumer;

public class FadingSporeParticle
extends MnTextureSheetParticle {
    private final float quadSizeMax;

    protected FadingSporeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int color, SpriteSet sprites) {
        super(level, x, y, z, sprites);
        this.m_172260_(xSpeed, ySpeed + 0.01, zSpeed);
        this.setInitialColor(color);
        this.f_107230_ = 1.0f;
        this.f_107663_ = 0.0f;
        this.quadSizeMax = this.f_107223_.m_188501_() * 0.5f + 0.5f;
        this.f_107224_ = (int)(8.0 / (this.f_107223_.m_188500_() * 0.8 + 0.2));
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
    }

    private void setInitialColor(int color) {
        ColorUtil.applyColorF((TriConsumer<Float, Float, Float>)((TriConsumer)(r, g, b) -> {
            Function<Float, Float> clamp = f -> Float.valueOf(Mth.m_14036_((float)(f.floatValue() + (this.f_107223_.m_188501_() * 0.2f - 0.1f)), (float)0.0f, (float)1.0f));
            this.m_107253_(clamp.apply((Float)r).floatValue(), clamp.apply((Float)g).floatValue(), clamp.apply((Float)b).floatValue());
        }), color);
    }

    @Override
    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.updateSprite();
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= 0.9;
            this.f_107217_ *= 0.9;
            float lifeRatio = (float)this.f_107224_ / (float)this.f_107225_;
            if (lifeRatio <= 0.25f) {
                this.f_107663_ = this.quadSizeMax * lifeRatio * 0.2f;
            } else {
                float lifeRatio2;
                this.f_107230_ = lifeRatio2 = lifeRatio / 0.75f;
                this.f_107663_ = this.quadSizeMax * (1.0f - lifeRatio2) * 0.05f;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    protected int m_6355_(float partialTick) {
        int skyLight = 10;
        int blockLight = 5;
        return skyLight << 20 | blockLight << 4;
    }

    public static ParticleProvider<SimpleParticleWithOneInt> provider(SpriteSet sprites) {
        return (type, level, x, y, z, xSpeed, ySpeed, zSpeed) -> new FadingSporeParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type.oneInt, sprites);
    }
}

