/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.model.entity;

import com.crypticmushroom.minecraft.midnight.client.model.entity.AnimatedEntityGeoModel;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Rifter;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class RifterModel<E extends Rifter>
extends AnimatedEntityGeoModel<E> {
    private float headRotX;
    private float headRotY;
    private float rightArmRotX;
    private float leftArmRotX;

    public RifterModel() {
        super(MnEntityTypes.RIFTER.getId().m_135815_());
    }

    public void setCustomAnimations(E entity, long instanceId, AnimationState<E> event) {
        super.setCustomAnimations(entity, instanceId, event);
        AnimationProcessor processor = this.getAnimationProcessor();
        CoreGeoBone head = processor.getBone("head");
        CoreGeoBone chest = processor.getBone("chest");
        CoreGeoBone abdomen = processor.getBone("abdomen");
        CoreGeoBone rightArm = processor.getBone("rightArm");
        CoreGeoBone leftArm = processor.getBone("leftArm");
        if (!Minecraft.m_91087_().m_91104_()) {
            this.headRotX = head.getRotX();
            this.headRotY = head.getRotY();
            this.rightArmRotX = rightArm.getRotX();
            this.leftArmRotX = leftArm.getRotX();
        }
        float offset = -chest.getRotX() + -abdomen.getRotX();
        EntityModelData extraData = (EntityModelData)event.getData(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(offset + this.headRotX + extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(this.headRotY + extraData.netHeadYaw() * ((float)Math.PI / 180));
        head.setRotZ(head.getRotY() * 0.2f);
        float limbSwing = event.getLimbSwing();
        float limbSwingAmount = event.getLimbSwingAmount();
        processor.getBone("rightLeg").setRotX(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        processor.getBone("leftLeg").setRotX(Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        if (!entity.m_20160_() && !Minecraft.m_91087_().m_91104_()) {
            this.rightArmRotX += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount;
            this.leftArmRotX += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount;
        }
        rightArm.setRotX(this.rightArmRotX + offset);
        leftArm.setRotX(this.leftArmRotX + offset);
    }
}

