/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.model.entity;

import com.crypticmushroom.minecraft.midnight.client.model.entity.AnimatedEntityGeoModel;
import com.crypticmushroom.minecraft.midnight.common.entity.living.creature.animal.NightstagEntity;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class NightstagModel<E extends NightstagEntity>
extends AnimatedEntityGeoModel<E> {
    private float headRotX;
    private float headRotY;
    private float frontRightLegRotX;

    public NightstagModel() {
        super(MnEntityTypes.NIGHTSTAG);
    }

    public void setCustomAnimations(E entity, long instanceId, AnimationState<E> event) {
        super.setCustomAnimations(entity, instanceId, event);
        AnimationProcessor processor = this.getAnimationProcessor();
        CoreGeoBone head = processor.getBone("headModel");
        CoreGeoBone frontRightLeg = processor.getBone("legFrontRight");
        EntityModelData extraData = (EntityModelData)event.getData(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(this.headRotX + extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(this.headRotY + extraData.netHeadYaw() * ((float)Math.PI / 180));
        float limbSwing = event.getLimbSwing();
        float limbSwingAmount = event.getLimbSwingAmount();
        frontRightLeg.setRotX(this.frontRightLegRotX + Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
        processor.getBone("legFrontLeft").setRotX(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        processor.getBone("legBackRight").setRotX(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount);
        processor.getBone("legBackLeft").setRotX(Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount);
    }
}

