/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.model.entity;

import com.crypticmushroom.minecraft.midnight.client.model.entity.AnimatedEntityGeoModel;
import com.crypticmushroom.minecraft.midnight.common.entity.living.monster.Hunter;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.data.EntityModelData;

public class HunterModel<E extends Hunter>
extends AnimatedEntityGeoModel<E> {
    public HunterModel() {
        super(MnEntityTypes.HUNTER);
    }

    public void setCustomAnimations(E animatable, long instanceId, AnimationState<E> state) {
        AnimationProcessor processor = this.getAnimationProcessor();
        CoreGeoBone core = processor.getBone("Core");
        CoreGeoBone tail = processor.getBone("Tail");
        CoreGeoBone tailMid = processor.getBone("TailMid");
        float rot = -Mth.m_14154_((float)animatable.m_5686_(state.getPartialTick())) * ((float)Math.PI / 180);
        float delta = this.getDelta(animatable, (float)((Hunter)((Object)animatable)).f_20913_ + state.getPartialTick() - 1.0f, 5);
        core.setRotX(Mth.m_14179_((float)delta, (float)(rot * 0.6f), (float)tailMid.getRotX()));
        tailMid.setRotX(Mth.m_14179_((float)delta, (float)(rot * 0.8f), (float)tailMid.getRotX()));
        tail.setRotX(Mth.m_14179_((float)delta, (float)rot, (float)tailMid.getRotX()));
        CoreGeoBone head = processor.getBone("Head");
        EntityModelData extraData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        head.setRotX(extraData.headPitch() * ((float)Math.PI / 180));
        head.setRotY(extraData.netHeadYaw() * ((float)Math.PI / 180));
        head.setRotZ(head.getRotY() * 0.2f);
    }

    private float getDelta(E animatable, float swingTime, int transitionTicks) {
        int swingDur = ((Hunter)((Object)animatable)).getAttackSwingDuration() - 1;
        float delta = swingTime <= (float)swingDur / 2.0f ? swingTime / (float)transitionTicks : (float)swingDur / (float)transitionTicks - swingTime / (float)transitionTicks;
        return Mth.m_14036_((float)delta, (float)0.0f, (float)1.0f);
    }
}

