/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.audio;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.client.audio.MnAmbienceTicker;
import com.crypticmushroom.minecraft.midnight.client.audio.MnMusic;
import com.crypticmushroom.minecraft.midnight.client.audio.MnMusicTicker;
import com.crypticmushroom.minecraft.midnight.client.audio.MnSoundReverb;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import com.crypticmushroom.minecraft.midnight.coremod.MidnightCoreMod;
import com.crypticmushroom.minecraft.midnight.coremod.reflection.ReflectionUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MnSoundSystem {
    static final Marker MARKER = MarkerManager.getMarker((String)"Client/SOUND_SYSTEM");
    private final MnMusicTicker music = new MnMusicTicker();
    private final MnAmbienceTicker ambience = new MnAmbienceTicker();
    private final MnSoundReverb soundReverb = new MnSoundReverb();

    static MnSoundSystem get() {
        return MidnightClient.get().getSoundSystem();
    }

    public MnMusicTicker getMusic() {
        return this.music;
    }

    public MnAmbienceTicker getAmbience() {
        return this.ambience;
    }

    public MnSoundReverb getSoundReverb() {
        return this.soundReverb;
    }

    public void addEventListeners(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onSoundSource);
        MinecraftForge.EVENT_BUS.addListener(this::onPlaySound);
        modBus.addListener(this::onSoundLoad);
    }

    void playSound(SoundInstance sound) {
        Minecraft.m_91087_().m_91106_().m_120367_(sound);
    }

    private void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END && event.type == TickEvent.Type.CLIENT && !mc.m_91104_()) {
            this.music.tick();
            this.ambience.tick();
            this.soundReverb.tick();
        }
    }

    private void onPlaySound(PlaySoundEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        SoundInstance sound = event.getSound();
        if (sound == null) {
            return;
        }
        if (sound.m_8070_() == SoundSource.MUSIC && mc.f_91074_ != null && MnDimensions.THE_MIDNIGHT.is(mc.f_91074_.m_9236_()) && !sound.m_7904_().toString().contains("midnight")) {
            Midnight.LOGGER.trace("Preventing {} from playing in the Midnight", (Object)sound.m_7904_());
            event.setSound(null);
        }
        if (ReflectionUtil.threadContains(ClientPacketListener.class, "m_6490_")) {
            SoundInstance musicSound = event.getOriginalSound();
            if (MnDimensions.THE_MIDNIGHT.is((Level)mc.f_91073_)) {
                MnMusic track = MnMusic.get(musicSound.m_7904_());
                musicSound = track != null ? MidnightClient.get().getSoundSystem().getMusic().prepareMusic(track, MnSoundSystem.getSoundVolume(musicSound), mc.f_91073_.f_46441_) : musicSound;
            }
            event.setSound(musicSound);
        }
    }

    private static Optional<Float> getSoundVolume(SoundInstance sound) {
        float volume = 1.0f;
        try {
            volume = sound.m_7769_();
        }
        catch (NullPointerException e) {
            if (sound instanceof AbstractSoundInstance) {
                AbstractSoundInstance realSound = (AbstractSoundInstance)sound;
                volume = realSound.f_119573_;
            }
            MidnightCoreMod.LOGGER.error(MARKER, "Failed to get the pitch for the Midnight music requested via /playsound! Defaulting to pitch of 100% (this is specific to the sound, not your game settings).", (Throwable)e);
        }
        return Optional.of(Float.valueOf(volume));
    }

    private void onSoundSource(SoundEvent.SoundSourceEvent event) {
        this.soundReverb.onPlaySound(event);
    }

    public void onSoundLoad(SoundEngineLoadEvent event) {
        this.soundReverb.onSoundLoad(event);
    }
}

