/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.audio;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.audio.AbstractFadableSoundInstance;
import com.crypticmushroom.minecraft.midnight.client.audio.MnMusicTicker;
import com.crypticmushroom.minecraft.midnight.client.audio.MnSoundSystem;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MnAmbienceTicker {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Client/AMBIENCE").addParents(new Marker[]{MnSoundSystem.MARKER});
    private int delay = 140;
    private RandomSource random = RandomSource.m_216327_();
    @Nullable
    private LongAmbientSound longAmbience;

    void tick() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        if (MnDimensions.THE_MIDNIGHT.is((Level)level) && player != null) {
            this.random = player.m_217043_();
        }
    }

    private void tickLongAmbience(ClientLevel level, LocalPlayer player) {
        Minecraft mc = Minecraft.m_91087_();
        MnMusicTicker music = MnSoundSystem.get().getMusic();
        if (mc.f_91066_.m_92147_(SoundSource.AMBIENT) <= 0.0f) {
            return;
        }
        if (this.longAmbience != null) {
            if (!mc.m_91106_().m_120403_((SoundInstance)this.longAmbience)) {
                Midnight.LOGGER.debug(MARKER, "Unsetting ambient music since it's not playing or has finished");
                this.longAmbience = null;
            } else if (this.longAmbience.m_7769_() <= 0.0f) {
                Midnight.LOGGER.trace(MARKER, "Unsetting long ambience since its pitch is at or below 0");
                this.longAmbience = null;
            }
        }
        if (music.isPlayingMusic()) {
            if (this.longAmbience != null && !this.longAmbience.shouldStop()) {
                Midnight.LOGGER.debug(MARKER, "Stopping long ambience");
                this.longAmbience.m_119609_();
            }
        } else if (this.longAmbience == null) {
            Midnight.LOGGER.debug(MARKER, "Playing long ambience");
        }
    }

    private void tickShortAmbience(ClientLevel level, LocalPlayer player) {
        MnMusicTicker music = MnSoundSystem.get().getMusic();
        if (player.m_6084_() && this.delay <= 0) {
            float ambientRandom = level.f_46441_.m_188501_();
            float f = music.isPlayingTrueMusic() ? 0.001f : 0.01f;
            if (ambientRandom < f) {
                this.delay = 140;
                float volume = music.isPlayingTrueMusic() ? 0.55f : 0.85f;
                float pitch = (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.2f + 1.0f;
                Midnight.LOGGER.debug(MARKER, "Playing a short ambient sound with a volume of {} and a pitch of {}.", (Object)Float.valueOf(pitch), (Object)Float.valueOf(volume));
            }
        } else {
            --this.delay;
        }
    }

    public LongAmbientSound prepareLongAmbience(LocalPlayer player, SoundEvent soundEvent) {
        this.longAmbience = new LongAmbientSound(soundEvent);
        return this.longAmbience;
    }

    public ShortAmbientSound prepareShortAmbience(LocalPlayer player, SoundEvent soundEvent) {
        return this.prepareShortAmbience(player, soundEvent, 0.7f);
    }

    public ShortAmbientSound prepareShortAmbience(LocalPlayer player, SoundEvent soundEvent, float volume) {
        return this.prepareShortAmbience(player, soundEvent, volume, 1.0f);
    }

    public ShortAmbientSound prepareShortAmbience(LocalPlayer player, SoundEvent soundEvent, float volume, float pitch) {
        return new ShortAmbientSound(player, soundEvent, volume, pitch);
    }

    private final class LongAmbientSound
    extends AbstractFadableSoundInstance {
        private LongAmbientSound(SoundEvent soundEvent) {
            super(soundEvent, SoundSource.AMBIENT, MnAmbienceTicker.this.random, 0.025f);
            this.f_119573_ = 0.85f;
        }
    }

    private final class ShortAmbientSound
    extends AbstractTickableSoundInstance {
        private final LocalPlayer player;

        private ShortAmbientSound(LocalPlayer player, SoundEvent soundEvent, float volume, float pitch) {
            super(soundEvent, SoundSource.AMBIENT, MnAmbienceTicker.this.random);
            this.f_119574_ = pitch;
            this.player = player;
            this.f_119578_ = false;
            this.f_119579_ = 0;
            this.f_119573_ = volume;
            this.f_119582_ = true;
        }

        public void m_7788_() {
            if (!this.player.m_6084_() || Minecraft.m_91087_().m_91104_()) {
                this.m_119609_();
            }
        }
    }
}

